/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public enum PacketResponse {
    ALL_BLOCKS_SUCCESSFULLY_RECEIVED("ALL BLOCKS RECEIVED", 8),
    ILLEGAL_FORMAT("ILLEGAL FORMAT", 64),
    PACKET_CRC_FAIL("PACKET CRC-32 FAILED", 72),
    MEMORY_FULL("MEMORY FULL", 80),
    FSN_OUT_OF_SEQUENCE("FSN OUT OF SEQUENCE", 88),
    UNDELIVERABLE("UNDELIVERABLE", 96),
    MSN_OUT_OF_SEQUENCE("MSG OUT OF SEQUENCE", 104),
    UNAUTHORIZED_USER("UNAUTHORIZED USER", 112),
    SELECTIVE_RETRY("SELECTIVE RETRY", 128),
    UNKNOWN("UNKNOWN", 255);

    private String mLabel;
    private int mMask;

    private PacketResponse(String label, int mask) {
        this.mLabel = label;
        this.mMask = mask;
    }

    public static PacketResponse fromValue(int value) {
        for (PacketResponse packetResponse : PacketResponse.values()) {
            if ((value & packetResponse.getMask()) != packetResponse.getMask()) continue;
            return packetResponse;
        }
        return UNKNOWN;
    }

    private int getMask() {
        return this.mMask;
    }

    public String toString() {
        return this.mLabel;
    }
}

