/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

import io.github.dsheirer.module.decode.p25.reference.AccessType;
import io.github.dsheirer.module.decode.p25.reference.Vocoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ChannelType {
    TYPE_0(AccessType.FDMA, 12500, 1, Vocoder.HALF_RATE),
    TYPE_1(AccessType.FDMA, 12500, 1, Vocoder.FULL_RATE),
    TYPE_2(AccessType.FDMA, 6250, 1, Vocoder.HALF_RATE),
    TYPE_3(AccessType.TDMA, 12500, 2, Vocoder.HALF_RATE),
    TYPE_4(AccessType.TDMA, 25000, 4, Vocoder.HALF_RATE),
    TYPE_5(AccessType.TDMA, 12500, 2, Vocoder.HALF_RATE),
    UNKNOWN(AccessType.UNKNOWN, 0, 1, Vocoder.HALF_RATE);

    private AccessType mAccessType;
    private int mBandwidth;
    private int mSlotsPerCarrier;
    private Vocoder mVocoder;
    private static final Logger mLog;

    private ChannelType(AccessType accessType, int bandwidth, int slots, Vocoder vocoder) {
        this.mAccessType = accessType;
        this.mBandwidth = bandwidth;
        this.mSlotsPerCarrier = slots;
        this.mVocoder = vocoder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTDMA()) {
            sb.append("TDMA");
            if (this.equals((Object)TYPE_5)) {
                sb.append(" H-D8PSK");
            }
            sb.append(" BW:").append(this.mBandwidth);
            sb.append(" TIMESLOTS:").append(this.mSlotsPerCarrier);
            sb.append(" VOCODER:").append(this.mVocoder.name());
        } else {
            sb.append("FDMA");
            sb.append(" BW:").append(this.mBandwidth);
            sb.append(" VOCODER:").append(this.mVocoder.name());
        }
        return sb.toString();
    }

    public boolean isTDMA() {
        return this.getAccessType() == AccessType.TDMA;
    }

    public static ChannelType fromValue(int value) {
        if (0 <= value && value <= 5) {
            return ChannelType.values()[value];
        }
        return UNKNOWN;
    }

    public AccessType getAccessType() {
        return this.mAccessType;
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public int getSlotsPerCarrier() {
        return this.mSlotsPerCarrier;
    }

    public Vocoder getVocoder() {
        return this.mVocoder;
    }

    static {
        mLog = LoggerFactory.getLogger(ChannelType.class);
    }
}

