/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.timeslot;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.FacchTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.SacchTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Timeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.UnknownTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Voice2Timeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Voice4Timeslot;

public class TimeslotFactory {
    public static Timeslot getTimeslot(CorrectedBinaryMessage message, BinaryMessage scramblingSequence, int timeslot, long timestamp) {
        DataUnitID dataUnitID = Timeslot.getDuid(message);
        switch (dataUnitID) {
            case VOICE_4: {
                return new Voice4Timeslot(message, scramblingSequence, timeslot, timestamp);
            }
            case VOICE_2: {
                return new Voice2Timeslot(message, scramblingSequence, timeslot, timestamp);
            }
            case SCRAMBLED_FACCH: {
                return new FacchTimeslot(message, scramblingSequence, timeslot, timestamp);
            }
            case SCRAMBLED_SACCH: {
                return new SacchTimeslot(message, scramblingSequence, timeslot, timestamp);
            }
            case UNSCRAMBLED_FACCH: {
                return new FacchTimeslot(message, timeslot, timestamp);
            }
            case UNSCRAMBLED_SACCH: {
                return new SacchTimeslot(message, timeslot, timestamp);
            }
        }
        return new UnknownTimeslot(message, timeslot, timestamp);
    }
}

