/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.timeslot;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.message.P25P2Message;

public abstract class Timeslot
extends P25P2Message {
    public static final int[] DATA_UNIT_ID = new int[]{0, 1, 74, 75, 244, 245, 318, 319};
    private CorrectedBinaryMessage mMessage;
    private DataUnitID mDataUnitID;
    private int mTimeslot;

    protected Timeslot(CorrectedBinaryMessage message, DataUnitID dataUnitID, BinaryMessage scramblingSequence, int timeslot, long timestamp) {
        this(message, dataUnitID, timeslot, timestamp);
        this.getMessage().xor(scramblingSequence);
    }

    protected Timeslot(CorrectedBinaryMessage message, DataUnitID dataUnitID, int timeslot, long timestamp) {
        super(timestamp);
        this.mMessage = message;
        this.mDataUnitID = dataUnitID;
        this.mTimeslot = timeslot;
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public DataUnitID getDataUnitID() {
        return this.mDataUnitID;
    }

    @Override
    public int getTimeslot() {
        return this.mTimeslot;
    }

    public static DataUnitID getDuid(CorrectedBinaryMessage message) {
        return DataUnitID.fromEncodedValue(message.getInt(DATA_UNIT_ID));
    }

    public String toString() {
        return this.getDataUnitID().toString();
    }
}

