/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.timeslot;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.LinearFeedbackShiftRegister;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScramblingSequence {
    private static final Logger mLog = LoggerFactory.getLogger(ScramblingSequence.class);
    private LinearFeedbackShiftRegister mShiftRegister = new LinearFeedbackShiftRegister();
    private List<BinaryMessage> mScramblingSegments = new ArrayList<BinaryMessage>();

    public ScramblingSequence() {
        for (int x = 0; x < 12; ++x) {
            this.mScramblingSegments.add(new BinaryMessage(320));
        }
    }

    public void update(ScrambleParameters parameters) {
        if (parameters != null) {
            this.update(parameters.getWACN(), parameters.getSystem(), parameters.getNAC());
        }
    }

    public void update(int wacn, int system, int nac) {
        if (!this.mShiftRegister.isCurrent(wacn, system, nac)) {
            this.mScramblingSegments.clear();
            BinaryMessage scramblingSequence = this.mShiftRegister.generateScramblingSequence(wacn, system, nac);
            for (int x = 20; x < 4320; x += 360) {
                this.mScramblingSegments.add(scramblingSequence.getSubMessage(x, x + 320));
            }
        }
    }

    public BinaryMessage getTimeslotSequence(int timeslot) {
        if (0 <= timeslot && timeslot <= 11) {
            return this.mScramblingSegments.get(timeslot);
        }
        throw new IllegalArgumentException("Unrecognized timeslot index: " + timeslot);
    }
}

