/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.l3harris;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.alias.P25TalkerAliasIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.ArrayList;
import java.util.List;

public class L3HarrisTalkerAlias
extends MacStructure {
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] LENGTH = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int ALIAS_START = 24;
    private List<Identifier> mIdentifiers;
    private P25TalkerAliasIdentifier mAliasIdentifier;

    public L3HarrisTalkerAlias(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getVendor() == Vendor.HARRIS) {
            sb.append("L3HARRIS ");
        } else {
            sb.append("WARNING: UNKNOWN VENDOR:").append((Object)this.getVendor());
        }
        sb.append(" TALKER ALIAS: ");
        sb.append(this.getAlias());
        return sb.toString();
    }

    public P25TalkerAliasIdentifier getAlias() {
        if (this.mAliasIdentifier == null) {
            int length = this.getLength() * 8;
            String alias = new String(this.getMessage().getSubMessage(24 + this.getOffset(), length + this.getOffset()).getBytes()).trim();
            this.mAliasIdentifier = P25TalkerAliasIdentifier.create(alias);
        }
        return this.mAliasIdentifier;
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR, this.getOffset()));
    }

    public int getLength() {
        return this.getMessage().getInt(LENGTH, this.getOffset());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getAlias());
        }
        return this.mIdentifiers;
    }
}

