/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.telephone.APCO25TelephoneNumber;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Digit;
import java.util.ArrayList;
import java.util.List;

public class TelephoneInterconnectAnswerRequest
extends MacStructure {
    private static final int[] DIGIT_1 = new int[]{8, 9, 10, 11};
    private static final int[] DIGIT_2 = new int[]{12, 13, 14, 15};
    private static final int[] DIGIT_3 = new int[]{16, 17, 18, 19};
    private static final int[] DIGIT_4 = new int[]{20, 21, 22, 23};
    private static final int[] DIGIT_5 = new int[]{24, 25, 26, 27};
    private static final int[] DIGIT_6 = new int[]{28, 29, 30, 31};
    private static final int[] DIGIT_7 = new int[]{32, 33, 34, 35};
    private static final int[] DIGIT_8 = new int[]{36, 37, 38, 39};
    private static final int[] DIGIT_9 = new int[]{40, 41, 42, 43};
    private static final int[] DIGIT_10 = new int[]{44, 45, 46, 47};
    private static final int[] TARGET_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress;
    private Identifier mTelephoneNumber;

    public TelephoneInterconnectAnswerRequest(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" TELEPHONE:").append(this.getTelephoneNumber());
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getTelephoneNumber() {
        if (this.mTelephoneNumber == null) {
            ArrayList<Integer> digits = new ArrayList<Integer>();
            digits.add(this.getMessage().getInt(DIGIT_1, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_2, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_3, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_4, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_5, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_6, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_7, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_8, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_9, this.getOffset()));
            digits.add(this.getMessage().getInt(DIGIT_10, this.getOffset()));
            this.mTelephoneNumber = APCO25TelephoneNumber.createAny(Digit.decode(digits));
        }
        return this.mTelephoneNumber;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getTelephoneNumber());
        }
        return this.mIdentifiers;
    }
}

