/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RfssStatusBroadcastAbbreviated
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] LRA = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int R = 18;
    private static final int A = 19;
    private static final int[] SYSTEM_ID = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RFSS_ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SITE_ID = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SERVICE_CLASS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private Identifier mLRA;
    private Identifier mSystem;
    private Identifier mRFSS;
    private Identifier mSite;
    private APCO25Channel mChannel;
    private SystemServiceClass mSystemServiceClass;

    public RfssStatusBroadcastAbbreviated(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" RFSS:").append(this.getRFSS());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" LRA:").append(this.getLRA());
        sb.append(" CHANNEL:").append(this.getChannel());
        sb.append(" SERVICES:").append(this.getSystemServiceClass().getServices());
        return sb.toString();
    }

    public Identifier getLRA() {
        if (this.mLRA == null) {
            this.mLRA = APCO25Lra.create(this.getMessage().getInt(LRA, this.getOffset()));
        }
        return this.mLRA;
    }

    public Identifier getRFSS() {
        if (this.mRFSS == null) {
            this.mRFSS = APCO25Rfss.create(this.getMessage().getInt(RFSS_ID, this.getOffset()));
        }
        return this.mRFSS;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE_ID, this.getOffset()));
        }
        return this.mSite;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM_ID, this.getOffset()));
        }
        return this.mSystem;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            P25Channel channel = new P25Channel(this.getMessage().getInt(FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(CHANNEL_NUMBER, this.getOffset()));
            this.mChannel = new APCO25Channel(channel);
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = SystemServiceClass.create(this.getMessage().getInt(SERVICE_CLASS, this.getOffset()));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLRA());
            this.mIdentifiers.add(this.getSystem());
            this.mIdentifiers.add(this.getRFSS());
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        return Collections.singletonList(this.getChannel());
    }
}

