/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.BER;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.RFLevel;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class PowerControlSignalQuality
extends MacStructure {
    private static final int[] TARGET_ADDRESS = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RF_LEVEL = new int[]{32, 33, 34, 35};
    private static final int[] BIT_ERROR_RATE = new int[]{36, 37, 38, 39};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress;

    public PowerControlSignalQuality(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" RF-LEVEL:").append((Object)this.getRFLevel());
        sb.append(" BER:").append((Object)this.getBitErrorRate());
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public RFLevel getRFLevel() {
        return RFLevel.fromValue(this.getMessage().getInt(RF_LEVEL, this.getOffset()));
    }

    public BER getBitErrorRate() {
        return BER.fromValue(this.getMessage().getInt(BIT_ERROR_RATE, this.getOffset()));
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }
}

