/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Nac;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetworkStatusBroadcastAbbreviated
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] LRA = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] WACN = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static final int[] SYSTEM_ID = new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FREQUENCY_BAND = new int[]{48, 49, 50, 51};
    private static final int[] CHANNEL_NUMBER = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SERVICE_CLASS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] COLOR_CODE = new int[]{76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private List<Identifier> mIdentifiers;
    private Identifier mLRA;
    private Identifier mWACN;
    private Identifier mSystem;
    private APCO25Channel mChannel;
    private SystemServiceClass mSystemServiceClass;
    private Identifier mNAC;

    public NetworkStatusBroadcastAbbreviated(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" WACN:").append(this.getWACN());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" NAC:").append(this.getNAC());
        sb.append(" LRA:").append(this.getLRA());
        sb.append(" CHANNEL:").append(this.getChannel());
        sb.append(" SERVICES:").append(this.getSystemServiceClass().getServices());
        return sb.toString();
    }

    public ScrambleParameters getScrambleParameters() {
        return new ScrambleParameters(this.getMessage().getInt(WACN, this.getOffset()), this.getMessage().getInt(SYSTEM_ID, this.getOffset()), this.getMessage().getInt(COLOR_CODE, this.getOffset()));
    }

    public Identifier getLRA() {
        if (this.mLRA == null) {
            this.mLRA = APCO25Lra.create(this.getMessage().getInt(LRA, this.getOffset()));
        }
        return this.mLRA;
    }

    public Identifier getWACN() {
        if (this.mWACN == null) {
            this.mWACN = APCO25Wacn.create(this.getMessage().getInt(WACN, this.getOffset()));
        }
        return this.mWACN;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM_ID, this.getOffset()));
        }
        return this.mSystem;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            P25Channel channel = new P25Channel(this.getMessage().getInt(FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(CHANNEL_NUMBER, this.getOffset()));
            this.mChannel = new APCO25Channel(channel);
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = SystemServiceClass.create(this.getMessage().getInt(SERVICE_CLASS, this.getOffset()));
        }
        return this.mSystemServiceClass;
    }

    public Identifier getNAC() {
        if (this.mNAC == null) {
            this.mNAC = APCO25Nac.create(this.getMessage().getInt(COLOR_CODE, this.getOffset()));
        }
        return this.mNAC;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLRA());
            this.mIdentifiers.add(this.getWACN());
            this.mIdentifiers.add(this.getSystem());
            this.mIdentifiers.add(this.getNAC());
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        return Collections.singletonList(this.getChannel());
    }
}

