/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class IndividualPagingMessage
extends MacStructure {
    private static final int PRIORITY_ID_1 = 8;
    private static final int PRIORITY_ID_2 = 9;
    private static final int PRIORITY_ID_3 = 10;
    private static final int PRIORITY_ID_4 = 11;
    private static final int[] ID_COUNT = new int[]{14, 15};
    private static final int[] TARGET_ADDRESS_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] TARGET_ADDRESS_2 = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] TARGET_ADDRESS_3 = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] TARGET_ADDRESS_4 = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress1;
    private Identifier mTargetAddress2;
    private Identifier mTargetAddress3;
    private Identifier mTargetAddress4;

    public IndividualPagingMessage(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" ID1:").append(this.getTargetAddress1());
        if (this.isTalkgroupPriority1()) {
            sb.append("-HIGH PRIORITY");
        } else {
            sb.append("-LOW PRIORITY");
        }
        int count = this.getCount();
        if (count > 1) {
            sb.append(" ID2:").append(this.getTargetAddress2());
            if (this.isTalkgroupPriority2()) {
                sb.append("-HIGH PRIORITY");
            } else {
                sb.append("-LOW PRIORITY");
            }
            if (count > 2) {
                sb.append(" ID3:").append(this.getTargetAddress3());
                if (this.isTalkgroupPriority3()) {
                    sb.append("-HIGH PRIORITY");
                } else {
                    sb.append("-LOW PRIORITY");
                }
                if (count > 3) {
                    sb.append(" ID4:").append(this.getTargetAddress4());
                    if (this.isTalkgroupPriority4()) {
                        sb.append("-HIGH PRIORITY");
                    } else {
                        sb.append("-LOW PRIORITY");
                    }
                }
            }
        }
        return sb.toString();
    }

    public static int getIdCount(BinaryMessage message, int offset) {
        return message.getInt(ID_COUNT, offset);
    }

    public int getCount() {
        return IndividualPagingMessage.getIdCount(this.getMessage(), this.getOffset());
    }

    public static int getLength(BinaryMessage message, int offset) {
        int count = IndividualPagingMessage.getIdCount(message, offset);
        switch (count) {
            case 1: {
                return 5;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
        }
        return 5;
    }

    public boolean isTalkgroupPriority1() {
        return this.getMessage().get(8 + this.getOffset());
    }

    public boolean isTalkgroupPriority2() {
        return this.getMessage().get(9 + this.getOffset());
    }

    public boolean isTalkgroupPriority3() {
        return this.getMessage().get(10 + this.getOffset());
    }

    public boolean isTalkgroupPriority4() {
        return this.getMessage().get(11 + this.getOffset());
    }

    public Identifier getTargetAddress1() {
        if (this.mTargetAddress1 == null) {
            this.mTargetAddress1 = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS_1, this.getOffset()));
        }
        return this.mTargetAddress1;
    }

    public Identifier getTargetAddress2() {
        if (this.mTargetAddress2 == null && this.getCount() >= 2) {
            this.mTargetAddress2 = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS_2, this.getOffset()));
        }
        return this.mTargetAddress2;
    }

    public Identifier getTargetAddress3() {
        if (this.mTargetAddress3 == null && this.getCount() >= 3) {
            this.mTargetAddress3 = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS_3, this.getOffset()));
        }
        return this.mTargetAddress3;
    }

    public Identifier getTargetAddress4() {
        if (this.mTargetAddress4 == null && this.getCount() >= 4) {
            this.mTargetAddress4 = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS_4, this.getOffset()));
        }
        return this.mTargetAddress4;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            int count = this.getCount();
            this.mIdentifiers.add(this.getTargetAddress1());
            if (count > 1) {
                this.mIdentifiers.add(this.getTargetAddress2());
                if (count > 2) {
                    this.mIdentifiers.add(this.getTargetAddress3());
                    if (count > 3) {
                        this.mIdentifiers.add(this.getTargetAddress4());
                    }
                }
            }
        }
        return this.mIdentifiers;
    }
}

