/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25FullyQualifiedRadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class GroupVoiceChannelUserExtended
extends MacStructure {
    private static final int[] SERVICE_OPTIONS = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] GROUP_ADDRESS = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] SOURCE_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FULLY_QUALIFIED_SOURCE_WACN = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75};
    private static final int[] FULLY_QUALIFIED_SOURCE_SYSTEM = new int[]{76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] FULLY_QUALIFIED_SOURCE_ID = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
    private List<Identifier> mIdentifiers;
    private VoiceServiceOptions mServiceOptions;
    private Identifier mGroupAddress;
    private Identifier mSourceAddress;
    private Identifier mSourceSuid;

    public GroupVoiceChannelUserExtended(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getGroupAddress());
        sb.append(" SUID:").append(this.getSourceSuid());
        sb.append(" ").append(this.getServiceOptions());
        return sb.toString();
    }

    public VoiceServiceOptions getServiceOptions() {
        if (this.mServiceOptions == null) {
            this.mServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS, this.getOffset()));
        }
        return this.mServiceOptions;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS, this.getOffset()));
        }
        return this.mGroupAddress;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    public Identifier getSourceSuid() {
        if (this.mSourceSuid == null) {
            int wacn = this.getMessage().getInt(FULLY_QUALIFIED_SOURCE_WACN, this.getOffset());
            int system = this.getMessage().getInt(FULLY_QUALIFIED_SOURCE_SYSTEM, this.getOffset());
            int id = this.getMessage().getInt(FULLY_QUALIFIED_SOURCE_ID, this.getOffset());
            this.mSourceSuid = APCO25FullyQualifiedRadioIdentifier.createFrom(wacn, system, id);
        }
        return this.mSourceSuid;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getSourceAddress());
            this.mIdentifiers.add(this.getSourceSuid());
        }
        return this.mIdentifiers;
    }
}

