/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.Collections;
import java.util.List;

public class FrequencyBandUpdateVUHF
extends MacStructure
implements IFrequencyBand {
    private static final int[] FREQUENCY_BAND_IDENTIFIER = new int[]{8, 9, 10, 11};
    private static final int[] BANDWIDTH = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20};
    private static final int TRANSMIT_OFFSET_SIGN = 21;
    private static final int[] TRANSMIT_OFFSET = new int[]{22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] CHANNEL_SPACING = new int[]{30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] BASE_FREQUENCY = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};

    public FrequencyBandUpdateVUHF(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" ID:").append(this.getIdentifier());
        sb.append(" OFFSET:").append(this.getTransmitOffset());
        sb.append(" SPACING:").append(this.getChannelSpacing());
        sb.append(" BASE:").append(this.getBaseFrequency());
        sb.append(" FDMA BW:").append(this.getBandwidth());
        return sb.toString();
    }

    @Override
    public int getIdentifier() {
        return this.getMessage().getInt(FREQUENCY_BAND_IDENTIFIER, this.getOffset());
    }

    @Override
    public long getChannelSpacing() {
        return this.getMessage().getInt(CHANNEL_SPACING, this.getOffset()) * 125;
    }

    @Override
    public long getBaseFrequency() {
        return this.getMessage().getLong(BASE_FREQUENCY, this.getOffset()) * 5L;
    }

    @Override
    public int getBandwidth() {
        int bandwidth = this.getMessage().getInt(BANDWIDTH, this.getOffset());
        if (bandwidth == 4) {
            return 6250;
        }
        if (bandwidth == 5) {
            return 12500;
        }
        return 0;
    }

    @Override
    public long getTransmitOffset() {
        long offset = this.getMessage().getLong(TRANSMIT_OFFSET, this.getOffset()) * this.getChannelSpacing();
        if (!this.getMessage().get(21 + this.getOffset())) {
            offset *= -1L;
        }
        return offset;
    }

    public boolean hasTransmitOffset() {
        return this.getMessage().getInt(TRANSMIT_OFFSET, this.getOffset()) != 128;
    }

    @Override
    public long getDownlinkFrequency(int channelNumber) {
        return this.getBaseFrequency() + this.getChannelSpacing() * (long)channelNumber;
    }

    @Override
    public long getUplinkFrequency(int channelNumber) {
        if (this.hasTransmitOffset()) {
            return this.getDownlinkFrequency(channelNumber) + this.getTransmitOffset();
        }
        return 0L;
    }

    @Override
    public boolean isTDMA() {
        return false;
    }

    @Override
    public int getTimeslotCount() {
        return 1;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

