/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Nac;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class EndPushToTalk
extends MacStructure {
    private static final int SYSTEM_CONTROLLER = 0xFFFFFF;
    private static int[] COLOR_CODE = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static int[] SOURCE_ADDRESS = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
    private static int[] GROUP_ADDRESS = new int[]{128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143};
    private Identifier mColorCode;
    private Identifier mSourceAddress;
    private Identifier mGroupAddress;
    private List<Identifier> mIdentifiers;

    public EndPushToTalk(CorrectedBinaryMessage message) {
        super(message, 0);
    }

    @Override
    public MacOpcode getOpcode() {
        return MacOpcode.END_PUSH_TO_TALK;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getGroupAddress());
        sb.append(" NAC:").append(this.getNAC());
        return sb.toString();
    }

    public Identifier getNAC() {
        if (this.mColorCode == null) {
            this.mColorCode = APCO25Nac.create(this.getMessage().getInt(COLOR_CODE, this.getOffset()));
        }
        return this.mColorCode;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS, this.getOffset()));
        }
        return this.mGroupAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceAddress());
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getNAC());
        }
        return this.mIdentifiers;
    }
}

