/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import java.util.List;

public abstract class MacStructure {
    private static int[] OPCODE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private CorrectedBinaryMessage mMessage;
    private int mOffset;

    protected MacStructure(CorrectedBinaryMessage message, int offset) {
        this.mMessage = message;
        this.mOffset = offset;
    }

    public abstract List<Identifier> getIdentifiers();

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    protected int getOffset() {
        return this.mOffset;
    }

    public static MacOpcode getOpcode(CorrectedBinaryMessage message, int offset) {
        return MacOpcode.fromValue(message.getInt(OPCODE, offset));
    }

    public static int getOpcodeNumber(CorrectedBinaryMessage message, int offset) {
        return message.getInt(OPCODE, offset);
    }

    public MacOpcode getOpcode() {
        return MacStructure.getOpcode(this.getMessage(), this.getOffset());
    }

    public int getOpcodeNumber() {
        return MacStructure.getOpcodeNumber(this.getMessage(), this.getOffset());
    }
}

