/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import java.util.Collection;
import java.util.function.Function;

public class MacOpcodeMessageFilter
extends Filter<IMessage, MacOpcode> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);
    private Collection<MacOpcode> mOpcodes;

    public MacOpcodeMessageFilter(String name, Collection<MacOpcode> opcodes) {
        super(name);
        this.mOpcodes = opcodes;
        for (MacOpcode opcode : opcodes) {
            this.add(new FilterElement<MacOpcode>(opcode));
        }
    }

    @Override
    public Function<IMessage, MacOpcode> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, MacOpcode> {
        private KeyExtractor(MacOpcodeMessageFilter macOpcodeMessageFilter) {
        }

        @Override
        public MacOpcode apply(IMessage message) {
            if (message instanceof MacMessage) {
                MacMessage mac = (MacMessage)message;
                return mac.getMacStructure().getOpcode();
            }
            return null;
        }
    }
}

