/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.enumeration;

public enum ISCHSequence {
    ISCH_1(0, "FRAG1", 0),
    ISCH_2(1, "FRAG2", 4),
    ISCH_3(2, "FRAG3", 8),
    RESERVED_4(3, "RSVD4", 0),
    UNKNOWN(-1, "UNKNO", 0);

    private int mValue;
    private String mLabel;
    private int mTimeslotOffset;

    private ISCHSequence(int value, String label, int timeslotOffset) {
        this.mValue = value;
        this.mLabel = label;
        this.mTimeslotOffset = timeslotOffset;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getTimeslotOffset() {
        return this.mTimeslotOffset;
    }

    public boolean isFinalFragment() {
        return this == ISCH_3;
    }

    public String toString() {
        return this.mLabel;
    }

    public static ISCHSequence fromValue(int value) {
        switch (value) {
            case 0: {
                return ISCH_1;
            }
            case 1: {
                return ISCH_2;
            }
            case 2: {
                return ISCH_3;
            }
            case 3: {
                return RESERVED_4;
            }
        }
        return UNKNOWN;
    }
}

