/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.dsp.symbol.Dibit;

public class P25P2SyncPattern {
    private static final Dibit[] SYNC_PATTERN = new Dibit[]{Dibit.D01_PLUS_3, Dibit.D01_PLUS_3, Dibit.D01_PLUS_3, Dibit.D11_MINUS_3, Dibit.D01_PLUS_3, Dibit.D01_PLUS_3, Dibit.D11_MINUS_3, Dibit.D01_PLUS_3, Dibit.D01_PLUS_3, Dibit.D01_PLUS_3, Dibit.D01_PLUS_3, Dibit.D11_MINUS_3, Dibit.D11_MINUS_3, Dibit.D11_MINUS_3, Dibit.D01_PLUS_3, Dibit.D11_MINUS_3, Dibit.D11_MINUS_3, Dibit.D11_MINUS_3, Dibit.D11_MINUS_3, Dibit.D11_MINUS_3};

    public static int getBitErrorCount(Dibit[] dibits) {
        if (dibits.length != 20) {
            throw new IllegalArgumentException("Sync pattern dibit array must be 20 dibits (40 bits) long");
        }
        int bitErrorCount = 0;
        for (int x = 0; x < 20; ++x) {
            if (SYNC_PATTERN[x] == dibits[x]) continue;
            int errorMask = SYNC_PATTERN[x].getLowValue() ^ dibits[x].getLowValue();
            if (errorMask == 3) {
                bitErrorCount += 2;
                continue;
            }
            ++bitErrorCount;
        }
        return bitErrorCount;
    }
}

