/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.channel.state.ChangeChannelTimeoutEvent;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.channel.state.TimeslotDecoderState;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.encryption.EncryptionKey;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.patch.PatchGroupManager;
import io.github.dsheirer.identifier.patch.PatchGroupPreLoadDataContent;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.PlottableDecodeEvent;
import io.github.dsheirer.module.decode.p25.P25DecodeEvent;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.P25P2NetworkConfigurationMonitor;
import io.github.dsheirer.module.decode.p25.phase2.message.EncryptionSynchronizationSequence;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacPduType;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.AcknowledgeResponse;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.CallAlertExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.DenyResponse;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.EndPushToTalk;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.ExtendedFunctionCommand;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.ExtendedFunctionCommandExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupAffiliationQueryExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelGrantAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelGrantUpdate;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelGrantUpdateExplicit;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelGrantUpdateMultiple;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelGrantUpdateMultipleExplicit;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelUserAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelUserExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceServiceRequest;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.IndividualPagingMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.MacRelease;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.MessageUpdateAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.MessageUpdateExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.PowerControlSignalQuality;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.PushToTalk;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.QueuedResponse;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.RadioUnitMonitorCommand;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.RadioUnitMonitorCommandEnhanced;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.RadioUnitMonitorCommandExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.SNDCPDataChannelGrant;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.SNDCPDataPageRequest;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.StatusQueryAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.StatusUpdateAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.StatusUpdateExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.TelephoneInterconnectAnswerRequest;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.TelephoneInterconnectVoiceChannelUser;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitAnswerRequestAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitAnswerRequestExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitVoiceChannelGrantAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitVoiceChannelGrantUpdateExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitVoiceChannelUserAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitVoiceChannelUserExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.l3harris.L3HarrisGpsLocation;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.l3harris.L3HarrisRegroupCommand;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.l3harris.L3HarrisTalkerAlias;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import io.github.dsheirer.protocol.Protocol;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2DecoderState
extends TimeslotDecoderState
implements IdentifierUpdateListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2DecoderState.class);
    private static int SYSTEM_CONTROLLER = 0xFFFFFF;
    private Channel.ChannelType mChannelType;
    private PatchGroupManager mPatchGroupManager = new PatchGroupManager();
    private P25P2NetworkConfigurationMonitor mNetworkConfigurationMonitor = new P25P2NetworkConfigurationMonitor();
    private DecodeEvent mCurrentCallEvent;
    private int mEndPttOnFacchCounter = 0;

    public P25P2DecoderState(Channel channel, int timeslot) {
        super(timeslot);
        this.mChannelType = channel.getChannelType();
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.P25_PHASE2;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetState();
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.closeCurrentCallEvent(System.currentTimeMillis(), true, MacPduType.MAC_3_IDLE);
        this.mEndPttOnFacchCounter = 0;
    }

    @Subscribe
    public void process(PatchGroupPreLoadDataContent preLoadDataContent) {
        for (Identifier identifier : ((IdentifierCollection)preLoadDataContent.getData()).getIdentifiers(Role.TO)) {
            if (!(identifier instanceof PatchGroupIdentifier)) continue;
            PatchGroupIdentifier patchGroupIdentifier = (PatchGroupIdentifier)identifier;
            this.mPatchGroupManager.addPatchGroup(patchGroupIdentifier);
        }
    }

    @Override
    public void receive(IMessage message) {
        if (message.isValid() && message.getTimeslot() == this.getTimeslot()) {
            if (message instanceof MacMessage) {
                MacMessage macMessage = (MacMessage)message;
                this.processMacMessage(macMessage);
                MacPduType macPduType = macMessage.getMacPduType();
                if (macPduType != MacPduType.MAC_2_END_PTT) {
                    this.mEndPttOnFacchCounter = 0;
                    this.continueState(P25P2DecoderState.getStateFromPduType(macPduType));
                }
                if (macPduType == MacPduType.MAC_3_IDLE) {
                    this.closeCurrentCallEvent(message.getTimestamp(), true, macPduType);
                }
            } else if (message instanceof AbstractVoiceTimeslot) {
                if (this.mCurrentCallEvent != null) {
                    if (this.isEncrypted()) {
                        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ENCRYPTED, this.getTimeslot()));
                    } else {
                        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CALL, this.getTimeslot()));
                    }
                }
                this.updateCurrentCall(null, null, message.getTimestamp());
            } else if (message instanceof EncryptionSynchronizationSequence) {
                this.getIdentifierCollection().update(message.getIdentifiers());
            }
        }
    }

    private static State getStateFromPduType(MacPduType macPduType) {
        switch (macPduType) {
            case MAC_1_PTT: {
                return State.CALL;
            }
            case MAC_2_END_PTT: {
                return State.TEARDOWN;
            }
            case MAC_4_ACTIVE: 
            case MAC_6_HANGTIME: {
                return State.ACTIVE;
            }
        }
        return State.IDLE;
    }

    private void broadcastCurrentChannel(APCO25Channel channel) {
        this.getIdentifierCollection().update(channel);
    }

    private void processMacMessage(MacMessage message) {
        this.mNetworkConfigurationMonitor.processMacMessage(message);
        MacStructure mac = message.getMacStructure();
        switch (mac.getOpcode()) {
            case PUSH_TO_TALK: {
                this.processPushToTalk(message, mac);
                break;
            }
            case END_PUSH_TO_TALK: {
                this.processEndPushToTalk(message, mac);
                break;
            }
            case TDMA_0_NULL_INFORMATION_MESSAGE: {
                MacPduType type = message.getMacPduType();
                if (type != MacPduType.MAC_3_IDLE && type != MacPduType.MAC_6_HANGTIME) break;
                this.closeCurrentCallEvent(message.getTimestamp(), true, type);
                break;
            }
            case TDMA_1_GROUP_VOICE_CHANNEL_USER_ABBREVIATED: {
                this.processGVCUAbbreviated(message, mac);
                break;
            }
            case TDMA_33_GROUP_VOICE_CHANNEL_USER_EXTENDED: {
                this.processGVCUExtended(message, mac);
                break;
            }
            case TDMA_2_UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                this.processUTUVCU(message, mac);
                break;
            }
            case TDMA_34_UNIT_TO_UNIT_VOICE_CHANNEL_USER_EXTENDED: {
                this.processUTUVCUExtended(message, mac);
                break;
            }
            case TDMA_3_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_USER: {
                this.processTIVCU(message, mac);
                break;
            }
            case TDMA_5_GROUP_VOICE_CHANNEL_GRANT_UPDATE_MULTIPLE: {
                this.processGVCGUM(mac);
                break;
            }
            case TDMA_37_GROUP_VOICE_CHANNEL_GRANT_UPDATE_MULTIPLE_EXPLICIT: {
                this.processGVCGUMExplicit(mac);
                break;
            }
            case PHASE1_64_GROUP_VOICE_CHANNEL_GRANT_ABBREVIATED: {
                this.processGVCGAbbreviated(mac);
                break;
            }
            case PHASE1_66_GROUP_VOICE_CHANNEL_GRANT_UPDATE: {
                this.processGVCGUpdate(mac);
                break;
            }
            case PHASE1_70_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT_UPDATE_ABBREVIATED: {
                this.processUTUVCGUAbbreviated(mac);
                break;
            }
            case PHASE1_195_GROUP_VOICE_CHANNEL_GRANT_UPDATE_EXPLICIT: {
                this.processGVCGUExplicit(mac);
                break;
            }
            case PHASE1_198_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT_UPDATE_EXTENDED: {
                this.processUTUVCGUExtended(mac);
                break;
            }
            case TDMA_17_INDIRECT_GROUP_PAGING: {
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.PAGE, "GROUP PAGE");
                break;
            }
            case TDMA_18_INDIVIDUAL_PAGING_MESSAGE_WITH_PRIORITY: {
                this.processIPMWP(message, mac);
                break;
            }
            case TDMA_48_POWER_CONTROL_SIGNAL_QUALITY: {
                this.processPCSQ(message, mac);
                break;
            }
            case TDMA_49_MAC_RELEASE: {
                this.processMacRelease(message, mac);
                break;
            }
            case PHASE1_65_GROUP_VOICE_SERVICE_REQUEST: {
                if (!(mac instanceof GroupVoiceServiceRequest)) break;
                GroupVoiceServiceRequest gvsr = (GroupVoiceServiceRequest)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.REQUEST, "GROUP VOICE SERVICE " + String.valueOf(gvsr.getServiceOptions()));
                break;
            }
            case PHASE1_68_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT_ABBREVIATED: {
                if (!(mac instanceof UnitToUnitVoiceChannelGrantAbbreviated)) break;
                UnitToUnitVoiceChannelGrantAbbreviated uuvcga = (UnitToUnitVoiceChannelGrantAbbreviated)mac;
                this.broadcast(message, mac, uuvcga.getChannel(), DecodeEventType.CALL_UNIT_TO_UNIT, "VOICE CHANNEL GRANT");
                break;
            }
            case PHASE1_69_UNIT_TO_UNIT_ANSWER_REQUEST_ABBREVIATED: {
                if (!(mac instanceof UnitToUnitAnswerRequestAbbreviated)) break;
                UnitToUnitAnswerRequestAbbreviated uuara = (UnitToUnitAnswerRequestAbbreviated)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.REQUEST, "UNIT-TO-UNIT ANSWER REQUEST - " + String.valueOf(uuara.getServiceOptions()));
                break;
            }
            case PHASE1_74_TELEPHONE_INTERCONNECT_ANSWER_REQUEST: {
                if (!(mac instanceof TelephoneInterconnectAnswerRequest)) break;
                TelephoneInterconnectAnswerRequest tiar = (TelephoneInterconnectAnswerRequest)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.REQUEST, "TELEPHONE INTERCONNECT ANSWER REQUEST");
                break;
            }
            case PHASE1_76_RADIO_UNIT_MONITOR_COMMAND_ABBREVIATED: {
                this.processRUMCA(message, mac);
                break;
            }
            case PHASE1_84_SNDCP_DATA_CHANNEL_GRANT: {
                this.processSDCG(message, mac);
                break;
            }
            case PHASE1_85_SNDCP_DATA_PAGE_REQUEST: {
                if (!(mac instanceof SNDCPDataPageRequest)) break;
                SNDCPDataPageRequest sdpr = (SNDCPDataPageRequest)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.PAGE, "SNDCP DATA PAGE " + String.valueOf(sdpr.getServiceOptions()));
                break;
            }
            case PHASE1_88_STATUS_UPDATE_ABBREVIATED: {
                this.processSUA(message, mac);
                break;
            }
            case PHASE1_90_STATUS_QUERY_ABBREVIATED: {
                if (!(mac instanceof StatusQueryAbbreviated)) break;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.STATUS, "STATUS QUERY");
                break;
            }
            case PHASE1_92_MESSAGE_UPDATE_ABBREVIATED: {
                if (!(mac instanceof MessageUpdateAbbreviated)) break;
                MessageUpdateAbbreviated mua = (MessageUpdateAbbreviated)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.SDM, "MESSAGE UPDATE - " + String.valueOf(mua.getShortDataMessage()));
                break;
            }
            case PHASE1_94_RADIO_UNIT_MONITOR_COMMAND_ENHANCED: {
                this.processRUMCE(message, mac);
                break;
            }
            case PHASE1_95_CALL_ALERT_ABBREVIATED: {
                this.processCallAlert(message, mac);
                break;
            }
            case PHASE1_96_ACK_RESPONSE: {
                if (!(mac instanceof AcknowledgeResponse)) break;
                AcknowledgeResponse ar = (AcknowledgeResponse)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.RESPONSE, "ACKNOWLEDGE: " + String.valueOf((Object)ar.getServiceType()));
                break;
            }
            case PHASE1_97_QUEUED_RESPONSE: {
                this.processQueuedResponse(message, mac);
                break;
            }
            case PHASE1_100_EXTENDED_FUNCTION_COMMAND_ABBREVIATED: {
                this.processEFCA(message, mac);
                break;
            }
            case PHASE1_103_DENY_RESPONSE: {
                this.processDenyResponse(message, mac);
                break;
            }
            case PHASE1_106_GROUP_AFFILIATION_QUERY_ABBREVIATED: {
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.QUERY, "GROUP AFFILIATION");
                break;
            }
            case PHASE1_109_UNIT_REGISTRATION_COMMAND_ABBREVIATED: {
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.COMMAND, "UNIT REGISTRATION");
                break;
            }
            case PHASE1_128_L3HARRIS_GPS_LOCATION: {
                this.processL3HarrisGps(message, mac);
                break;
            }
            case PHASE1_168_L3HARRIS_TALKER_ALIAS: {
                if (!(mac instanceof L3HarrisTalkerAlias)) break;
                L3HarrisTalkerAlias talkerAlias = (L3HarrisTalkerAlias)mac;
                this.getIdentifierCollection().update(talkerAlias.getAlias());
                break;
            }
            case PHASE1_176_L3HARRIS_GROUP_REGROUP: {
                if (!(mac instanceof L3HarrisRegroupCommand)) break;
                L3HarrisRegroupCommand regroup = (L3HarrisRegroupCommand)mac;
                if (regroup.getRegroupOptions().isActivate()) {
                    this.mPatchGroupManager.addPatchGroup(regroup.getPatchGroup());
                    break;
                }
                this.mPatchGroupManager.removePatchGroup(regroup.getPatchGroup());
                break;
            }
            case PHASE1_197_UNIT_TO_UNIT_ANSWER_REQUEST_EXTENDED: {
                if (!(mac instanceof UnitToUnitAnswerRequestExtended)) break;
                UnitToUnitAnswerRequestExtended uuare = (UnitToUnitAnswerRequestExtended)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.REQUEST, "UNIT-TO-UNIT ANSWER REQUEST " + String.valueOf(uuare.getServiceOptions()));
                break;
            }
            case PHASE1_204_RADIO_UNIT_MONITOR_COMMAND_EXTENDED: {
                this.processRUMCExtended(message, mac);
                break;
            }
            case PHASE1_216_STATUS_UPDATE_EXTENDED: {
                this.processSUE(message, mac);
                break;
            }
            case PHASE1_218_STATUS_QUERY_EXTENDED: {
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.STATUS, "STATUS QUERY");
                break;
            }
            case PHASE1_220_MESSAGE_UPDATE_EXTENDED: {
                if (!(mac instanceof MessageUpdateExtended)) break;
                MessageUpdateExtended mue = (MessageUpdateExtended)mac;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.SDM, "MESSAGE UPDATE - " + String.valueOf(mue.getShortDataMessage()));
                break;
            }
            case PHASE1_223_CALL_ALERT_EXTENDED: {
                if (!(mac instanceof CallAlertExtended)) break;
                this.processCallAlert(message, mac);
                break;
            }
            case PHASE1_228_EXTENDED_FUNCTION_COMMAND_EXTENDED: {
                this.processEFCE(message, mac);
                break;
            }
            case PHASE1_234_GROUP_AFFILIATION_QUERY_EXTENDED: {
                if (!(mac instanceof GroupAffiliationQueryExtended)) break;
                this.broadcast(message, mac, this.getCurrentChannel(), DecodeEventType.QUERY, "GROUP AFFILIATION");
                break;
            }
        }
    }

    private void processQueuedResponse(MacMessage message, MacStructure mac) {
        if (mac instanceof QueuedResponse) {
            QueuedResponse qr = (QueuedResponse)mac;
            this.broadcast(message, mac, DecodeEventType.RESPONSE, "QUEUED - " + String.valueOf((Object)qr.getQueuedResponseServiceType()) + " REASON:" + String.valueOf((Object)qr.getQueuedResponseReason()) + " ADDL:" + qr.getAdditionalInfo());
        }
    }

    private void processEFCA(MacMessage message, MacStructure mac) {
        if (mac instanceof ExtendedFunctionCommand) {
            ExtendedFunctionCommand efc = (ExtendedFunctionCommand)mac;
            this.broadcast(message, mac, DecodeEventType.COMMAND, "EXTENDED FUNCTION: " + String.valueOf((Object)efc.getExtendedFunction()) + " ARGUMENTS:" + efc.getArguments());
        }
    }

    private void processDenyResponse(MacMessage message, MacStructure mac) {
        if (mac instanceof DenyResponse) {
            DenyResponse dr = (DenyResponse)mac;
            this.broadcast(message, mac, DecodeEventType.RESPONSE, "DENY: " + String.valueOf((Object)dr.getDeniedServiceType()) + " REASON:" + String.valueOf((Object)dr.getDenyReason()) + " ADDL:" + dr.getAdditionalInfo());
        }
    }

    private void processRUMCExtended(MacMessage message, MacStructure mac) {
        if (mac instanceof RadioUnitMonitorCommandExtended) {
            RadioUnitMonitorCommandExtended rumce = (RadioUnitMonitorCommandExtended)mac;
            this.broadcast(message, mac, DecodeEventType.COMMAND, "RADIO UNIT MONITOR" + (rumce.isSilentMonitor() ? " (STEALTH)" : "") + " TIME:" + rumce.getTransmitTime() + "MULTIPLIER:" + rumce.getTransmitMultiplier());
        }
    }

    private void processSUE(MacMessage message, MacStructure mac) {
        if (mac instanceof StatusUpdateExtended) {
            StatusUpdateExtended sue = (StatusUpdateExtended)mac;
            this.broadcast(message, mac, DecodeEventType.STATUS, "STATUS UPDATE - UNIT:" + String.valueOf(sue.getUnitStatus()) + " USER:" + String.valueOf(sue.getUserStatus()));
        }
    }

    private void processEFCE(MacMessage message, MacStructure mac) {
        if (mac instanceof ExtendedFunctionCommandExtended) {
            ExtendedFunctionCommandExtended efce = (ExtendedFunctionCommandExtended)mac;
            this.broadcast(message, mac, DecodeEventType.COMMAND, "EXTENDED FUNCTION: " + String.valueOf((Object)efce.getExtendedFunction()) + " ARGUMENTS:" + efce.getArguments());
        }
    }

    private void processCallAlert(MacMessage message, MacStructure mac) {
        this.broadcast(message, mac, DecodeEventType.CALL_ALERT, null);
    }

    private void processRUMCE(MacMessage message, MacStructure mac) {
        if (mac instanceof RadioUnitMonitorCommandEnhanced) {
            RadioUnitMonitorCommandEnhanced rumc = (RadioUnitMonitorCommandEnhanced)mac;
            this.broadcast(message, mac, DecodeEventType.COMMAND, "RADIO UNIT MONITOR" + (rumc.isStealthMode() ? " (STEALTH)" : "") + " ENCRYPTION:" + String.valueOf((Object)rumc.getEncryption()) + " TIME:" + rumc.getTransmitTime());
        }
    }

    private void processSUA(MacMessage message, MacStructure mac) {
        if (mac instanceof StatusUpdateAbbreviated) {
            StatusUpdateAbbreviated sua = (StatusUpdateAbbreviated)mac;
            this.broadcast(message, mac, DecodeEventType.STATUS, "STATUS UPDATE - UNIT:" + String.valueOf(sua.getUnitStatus()) + " USER:" + String.valueOf(sua.getUserStatus()));
        }
    }

    private void processSDCG(MacMessage message, MacStructure mac) {
        if (mac instanceof SNDCPDataChannelGrant) {
            SNDCPDataChannelGrant sdcg = (SNDCPDataChannelGrant)mac;
            this.broadcast(message, mac, sdcg.getServiceOptions().isEncrypted() ? DecodeEventType.DATA_CALL_ENCRYPTED : DecodeEventType.DATA_CALL, "SNDCP CHANNEL GRANT " + String.valueOf(sdcg.getServiceOptions()));
        }
    }

    private void processRUMCA(MacMessage message, MacStructure mac) {
        if (mac instanceof RadioUnitMonitorCommand) {
            RadioUnitMonitorCommand rumc = (RadioUnitMonitorCommand)mac;
            this.broadcast(message, mac, DecodeEventType.COMMAND, "RADIO UNIT MONITOR" + (rumc.isSilentMonitor() ? " (STEALTH)" : "") + " TIME:" + rumc.getTransmitTime() + " MULTIPLIER:" + rumc.getTransmitMultiplier());
        }
    }

    private void processMacRelease(MacMessage message, MacStructure mac) {
        if (mac instanceof MacRelease) {
            MacRelease mr = (MacRelease)mac;
            this.closeCurrentCallEvent(message.getTimestamp(), true, message.getMacPduType());
            this.broadcast(message, mac, DecodeEventType.COMMAND, (mr.isForcedPreemption() ? "FORCED " : "") + "CALL PREEMPTION" + (mr.isTalkerPreemption() ? " BY USER" : ""));
        }
    }

    private void processPCSQ(MacMessage message, MacStructure mac) {
        if (mac instanceof PowerControlSignalQuality) {
            PowerControlSignalQuality pcsq = (PowerControlSignalQuality)mac;
            this.broadcast(message, mac, DecodeEventType.COMMAND, "ADJUST TRANSMIT POWER - RF:" + String.valueOf((Object)pcsq.getRFLevel()) + " BER:" + String.valueOf((Object)pcsq.getBitErrorRate()));
        }
    }

    private void processIPMWP(MacMessage message, MacStructure mac) {
        if (mac instanceof IndividualPagingMessage) {
            IndividualPagingMessage ipm = (IndividualPagingMessage)mac;
            boolean priority = ipm.isTalkgroupPriority1() || ipm.isTalkgroupPriority2() || ipm.isTalkgroupPriority3() || ipm.isTalkgroupPriority4();
            this.broadcast(message, mac, DecodeEventType.PAGE, (priority ? "PRIORITY " : "") + "USER PAGE");
        }
    }

    private void processL3HarrisGps(MacMessage message, MacStructure structure) {
        if (structure instanceof L3HarrisGpsLocation) {
            L3HarrisGpsLocation gps = (L3HarrisGpsLocation)structure;
            MutableIdentifierCollection collection = this.getUpdatedMutableIdentifierCollection(gps);
            this.broadcast(PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, message.getTimestamp()).protocol(Protocol.APCO25).location(gps.getGeoPosition()).channel(this.getCurrentChannel()).details(gps.getLocation().toString() + " " + String.valueOf(new Date(gps.getTimestampMs()))).identifiers(collection).build());
        }
    }

    private void broadcast(MacMessage message, MacStructure mac, IChannelDescriptor currentChannel, DecodeEventType eventType, String details) {
        MutableIdentifierCollection collection = this.getUpdatedMutableIdentifierCollection(mac);
        this.broadcast(P25DecodeEvent.builder(eventType, message.getTimestamp()).channel(currentChannel).details(details).identifiers(collection).build());
    }

    private void broadcast(MacMessage message, MacStructure structure, DecodeEventType eventType, String details) {
        MutableIdentifierCollection icQueuedResponse = this.getUpdatedMutableIdentifierCollection(structure);
        this.broadcast(P25DecodeEvent.builder(eventType, message.getTimestamp()).channel(this.getCurrentChannel()).details(details).identifiers(icQueuedResponse).build());
    }

    private MutableIdentifierCollection getUpdatedMutableIdentifierCollection(MacStructure mac) {
        MutableIdentifierCollection icQueuedResponse = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
        icQueuedResponse.remove(IdentifierClass.USER);
        icQueuedResponse.update(mac.getIdentifiers());
        return icQueuedResponse;
    }

    private void processUTUVCGUExtended(MacStructure mac) {
        UnitToUnitVoiceChannelGrantUpdateExtended uuvcgue;
        if (this.getCurrentChannel() == null && mac instanceof UnitToUnitVoiceChannelGrantUpdateExtended && this.isCurrentGroup((uuvcgue = (UnitToUnitVoiceChannelGrantUpdateExtended)mac).getTargetAddress())) {
            this.broadcastCurrentChannel(uuvcgue.getChannel());
        }
    }

    private void processGVCGUExplicit(MacStructure mac) {
        GroupVoiceChannelGrantUpdateExplicit gvcgue;
        if (this.getCurrentChannel() == null && mac instanceof GroupVoiceChannelGrantUpdateExplicit && this.isCurrentGroup((gvcgue = (GroupVoiceChannelGrantUpdateExplicit)mac).getGroupAddress())) {
            this.broadcastCurrentChannel(gvcgue.getChannel());
        }
    }

    private void processUTUVCGUAbbreviated(MacStructure mac) {
        UnitToUnitVoiceChannelGrantAbbreviated uuvcga;
        if (this.getCurrentChannel() == null && mac instanceof UnitToUnitVoiceChannelGrantAbbreviated && (this.isCurrentGroup((uuvcga = (UnitToUnitVoiceChannelGrantAbbreviated)mac).getSourceAddress()) || this.isCurrentGroup(uuvcga.getTargetAddress()))) {
            this.broadcastCurrentChannel(uuvcga.getChannel());
        }
    }

    private void processGVCGUpdate(MacStructure mac) {
        if (this.getCurrentChannel() == null && mac instanceof GroupVoiceChannelGrantUpdate) {
            GroupVoiceChannelGrantUpdate gvcgu = (GroupVoiceChannelGrantUpdate)mac;
            if (this.isCurrentGroup(gvcgu.getGroupAddressA())) {
                this.broadcastCurrentChannel(gvcgu.getChannelA());
            }
            if (this.getCurrentChannel() == null && this.isCurrentGroup(gvcgu.getGroupAddressB())) {
                this.broadcastCurrentChannel(gvcgu.getChannelB());
            }
        }
    }

    private void processGVCGAbbreviated(MacStructure mac) {
        GroupVoiceChannelGrantAbbreviated gvcga;
        if (this.getCurrentChannel() == null && mac instanceof GroupVoiceChannelGrantAbbreviated && this.isCurrentGroup((gvcga = (GroupVoiceChannelGrantAbbreviated)mac).getGroupAddress())) {
            this.broadcastCurrentChannel(gvcga.getChannel());
        }
    }

    private void processGVCGUMExplicit(MacStructure mac) {
        if (this.getCurrentChannel() == null && mac instanceof GroupVoiceChannelGrantUpdateMultipleExplicit) {
            GroupVoiceChannelGrantUpdateMultipleExplicit gvcgume = (GroupVoiceChannelGrantUpdateMultipleExplicit)mac;
            if (this.isCurrentGroup(gvcgume.getGroupAddressA())) {
                this.broadcastCurrentChannel(gvcgume.getChannelA());
            }
            if (this.getCurrentChannel() == null && this.isCurrentGroup(gvcgume.getGroupAddressB())) {
                this.broadcastCurrentChannel(gvcgume.getChannelB());
            }
        }
    }

    private void processGVCGUM(MacStructure mac) {
        if (this.getCurrentChannel() == null && mac instanceof GroupVoiceChannelGrantUpdateMultiple) {
            GroupVoiceChannelGrantUpdateMultiple gvcgum = (GroupVoiceChannelGrantUpdateMultiple)mac;
            if (this.isCurrentGroup(gvcgum.getGroupAddressA())) {
                this.broadcastCurrentChannel(gvcgum.getChannelA());
            }
            if (this.getCurrentChannel() == null && gvcgum.hasGroupB() && this.isCurrentGroup(gvcgum.getGroupAddressB())) {
                this.broadcastCurrentChannel(gvcgum.getChannelB());
            }
            if (this.getCurrentChannel() == null && gvcgum.hasGroupC() && this.isCurrentGroup(gvcgum.getGroupAddressC())) {
                this.broadcastCurrentChannel(gvcgum.getChannelC());
            }
        }
    }

    private void processTIVCU(MacMessage message, MacStructure mac) {
        if (message.getMacPduType() == MacPduType.MAC_6_HANGTIME) {
            this.closeCurrentCallEvent(message.getTimestamp(), false, MacPduType.MAC_6_HANGTIME);
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
        } else {
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            if (mac instanceof TelephoneInterconnectVoiceChannelUser) {
                TelephoneInterconnectVoiceChannelUser tivcu = (TelephoneInterconnectVoiceChannelUser)mac;
                if (tivcu.getServiceOptions().isEncrypted()) {
                    this.updateCurrentCall(DecodeEventType.CALL_INTERCONNECT_ENCRYPTED, null, message.getTimestamp());
                } else {
                    this.updateCurrentCall(DecodeEventType.CALL_INTERCONNECT, null, message.getTimestamp());
                }
            }
        }
    }

    private void processUTUVCUExtended(MacMessage message, MacStructure mac) {
        if (message.getMacPduType() == MacPduType.MAC_6_HANGTIME) {
            this.closeCurrentCallEvent(message.getTimestamp(), false, MacPduType.MAC_6_HANGTIME);
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
        } else {
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            if (mac instanceof UnitToUnitVoiceChannelUserExtended) {
                UnitToUnitVoiceChannelUserExtended uuvcue = (UnitToUnitVoiceChannelUserExtended)mac;
                if (uuvcue.getServiceOptions().isEncrypted()) {
                    this.updateCurrentCall(DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED, null, message.getTimestamp());
                } else {
                    this.updateCurrentCall(DecodeEventType.CALL_UNIT_TO_UNIT, null, message.getTimestamp());
                }
            }
        }
    }

    private void processUTUVCU(MacMessage message, MacStructure mac) {
        if (message.getMacPduType() == MacPduType.MAC_6_HANGTIME) {
            this.closeCurrentCallEvent(message.getTimestamp(), false, MacPduType.MAC_6_HANGTIME);
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
        } else {
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            if (mac instanceof UnitToUnitVoiceChannelUserAbbreviated) {
                UnitToUnitVoiceChannelUserAbbreviated uuvcua = (UnitToUnitVoiceChannelUserAbbreviated)mac;
                if (uuvcua.getServiceOptions().isEncrypted()) {
                    this.updateCurrentCall(DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED, null, message.getTimestamp());
                } else {
                    this.updateCurrentCall(DecodeEventType.CALL_UNIT_TO_UNIT, null, message.getTimestamp());
                }
            }
        }
    }

    private void processGVCUExtended(MacMessage message, MacStructure mac) {
        if (message.getMacPduType() == MacPduType.MAC_6_HANGTIME) {
            this.closeCurrentCallEvent(message.getTimestamp(), false, MacPduType.MAC_6_HANGTIME);
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
        } else {
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            if (mac instanceof GroupVoiceChannelUserExtended) {
                GroupVoiceChannelUserExtended gvcue = (GroupVoiceChannelUserExtended)mac;
                if (gvcue.getServiceOptions().isEncrypted()) {
                    this.updateCurrentCall(DecodeEventType.CALL_GROUP_ENCRYPTED, null, message.getTimestamp());
                } else {
                    this.updateCurrentCall(DecodeEventType.CALL_GROUP, null, message.getTimestamp());
                }
            }
        }
    }

    private void processGVCUAbbreviated(MacMessage message, MacStructure mac) {
        if (message.getMacPduType() == MacPduType.MAC_6_HANGTIME) {
            this.closeCurrentCallEvent(message.getTimestamp(), false, MacPduType.MAC_6_HANGTIME);
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
        } else {
            for (Identifier identifier : mac.getIdentifiers()) {
                this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
            }
            if (mac instanceof GroupVoiceChannelUserAbbreviated) {
                GroupVoiceChannelUserAbbreviated gvcua = (GroupVoiceChannelUserAbbreviated)mac;
                if (gvcua.getServiceOptions().isEncrypted()) {
                    this.updateCurrentCall(DecodeEventType.CALL_GROUP_ENCRYPTED, null, message.getTimestamp());
                } else {
                    this.updateCurrentCall(DecodeEventType.CALL_GROUP, null, message.getTimestamp());
                }
            }
        }
    }

    private void processEndPushToTalk(MacMessage message, MacStructure mac) {
        if (mac instanceof EndPushToTalk) {
            if (this.mCurrentCallEvent != null) {
                for (Identifier identifier : mac.getIdentifiers()) {
                    int value;
                    if (identifier.getRole() == Role.FROM) {
                        if (!(identifier instanceof APCO25RadioIdentifier) || (value = ((Integer)((APCO25RadioIdentifier)identifier).getValue()).intValue()) == SYSTEM_CONTROLLER) continue;
                        this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
                        continue;
                    }
                    if (identifier.getRole() == Role.TO) {
                        if (!(identifier instanceof APCO25Talkgroup) || (value = ((Integer)((APCO25Talkgroup)identifier).getValue()).intValue()) == 0) continue;
                        this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
                        continue;
                    }
                    this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
                }
            }
            if (message.getDataUnitID().isFACCH()) {
                ++this.mEndPttOnFacchCounter;
                if (this.mEndPttOnFacchCounter > 1) {
                    if (this.mChannelType == Channel.ChannelType.TRAFFIC) {
                        this.closeCurrentCallEvent(message.getTimestamp(), true, MacPduType.MAC_2_END_PTT);
                    } else {
                        this.closeCurrentCallEvent(message.getTimestamp(), true, MacPduType.MAC_4_ACTIVE);
                        this.continueState(State.RESET);
                    }
                }
            } else {
                this.closeCurrentCallEvent(message.getTimestamp(), true, MacPduType.MAC_4_ACTIVE);
            }
        }
    }

    private void processPushToTalk(MacMessage message, MacStructure mac) {
        for (Identifier identifier : mac.getIdentifiers()) {
            this.getIdentifierCollection().update(this.mPatchGroupManager.update(identifier));
        }
        PushToTalk ptt = (PushToTalk)mac;
        if (ptt.isEncrypted()) {
            this.updateCurrentCall(DecodeEventType.CALL_ENCRYPTED, ptt.getEncryptionKey().toString(), message.getTimestamp());
        } else {
            this.updateCurrentCall(DecodeEventType.CALL, null, message.getTimestamp());
        }
    }

    private boolean isCurrentGroup(Identifier<?> identifier) {
        if (identifier != null) {
            for (Identifier id : this.getIdentifierCollection().getIdentifiers(Role.TO)) {
                if (!identifier.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private void continueState(State state) {
        if (this.mCurrentCallEvent != null) {
            this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CALL, this.getTimeslot()));
        } else {
            this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.DECODE, state, this.getTimeslot()));
        }
    }

    private void updateCurrentCall(DecodeEventType type, String details, long timestamp) {
        if (this.mCurrentCallEvent == null) {
            if (type == null) {
                type = DecodeEventType.CALL;
            }
            this.mCurrentCallEvent = P25DecodeEvent.builder(type, timestamp).channel(this.getCurrentChannel()).details(details).identifiers(this.getIdentifierCollection().copyOf()).build();
            this.broadcast(this.mCurrentCallEvent);
            if (this.isEncrypted()) {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.ENCRYPTED, this.getTimeslot()));
            } else {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.CALL, this.getTimeslot()));
            }
        } else {
            if (details != null) {
                this.mCurrentCallEvent.setDetails(details);
            }
            this.mCurrentCallEvent.setIdentifierCollection(this.getIdentifierCollection().copyOf());
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
        }
    }

    private void closeCurrentCallEvent(long timestamp, boolean resetIdentifiers, MacPduType pduType) {
        if (this.mCurrentCallEvent != null) {
            this.mCurrentCallEvent.setIdentifierCollection(this.getIdentifierCollection().copyOf());
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
            this.mCurrentCallEvent = null;
            this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.END, P25P2DecoderState.getStateFromPduType(pduType), this.getTimeslot()));
            if (resetIdentifiers) {
                this.getIdentifierCollection().remove(IdentifierClass.USER);
            } else {
                this.getIdentifierCollection().remove(IdentifierClass.USER, Role.FROM);
            }
        } else if (pduType == MacPduType.MAC_2_END_PTT) {
            this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.END, P25P2DecoderState.getStateFromPduType(pduType), this.getTimeslot()));
        }
    }

    private boolean isEncrypted() {
        for (Identifier identifier : this.getIdentifierCollection().getIdentifiers(Form.ENCRYPTION_KEY)) {
            if (!(identifier.getValue() instanceof EncryptionKey) || !((EncryptionKey)identifier.getValue()).isEncrypted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getActivitySummary() {
        return this.mNetworkConfigurationMonitor.getActivitySummary();
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        if (event.getTimeslot() == this.getTimeslot()) {
            switch (event.getEvent()) {
                case REQUEST_RESET: {
                    this.resetState();
                    this.mNetworkConfigurationMonitor.reset();
                    break;
                }
            }
        }
    }

    @Override
    public void start() {
        this.mPatchGroupManager.clear();
        if (this.mChannelType == Channel.ChannelType.TRAFFIC) {
            this.broadcast(new ChangeChannelTimeoutEvent((Object)this, Channel.ChannelType.TRAFFIC, 1000L, this.getTimeslot()));
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void stop() {
        this.mPatchGroupManager.clear();
    }
}

