/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SyncBroadcast
extends OSPMessage {
    public static final int[] RESERVED = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
    public static final int SYSTEM_TIME_NOT_LOCKED_TO_EXTERNAL_REFERENCE_FLAG = 29;
    public static final int MICRO_SLOTS_TO_MINUTE_ROLLOVER_UNLOCKED_FLAG = 30;
    public static final int[] LEAP_SECOND_CORRECTION = new int[]{31, 32};
    public static final int LOCAL_TIME_OFFSET_VALID_FLAG = 33;
    public static final int LOCAL_TIME_OFFSET_SIGN = 34;
    public static final int[] LOCAL_TIME_OFFSET_HOURS = new int[]{35, 36, 37, 38};
    public static final int LOCAL_TIME_OFFSET_HALF_HOUR = 39;
    public static final int[] YEAR = new int[]{40, 41, 42, 43, 44, 45, 46};
    public static final int[] MONTH = new int[]{47, 48, 49, 50};
    public static final int[] DAY = new int[]{51, 52, 53, 54, 55};
    public static final int[] HOURS = new int[]{56, 57, 58, 59, 60};
    public static final int[] MINUTES = new int[]{61, 62, 63, 65, 65, 66};
    public static final int[] MICRO_SLOTS = new int[]{67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final DateFormat TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    private static final TimeZone NO_TIME_ZONE = new SimpleTimeZone(0, "NONE");

    public SyncBroadcast(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" SYSTEM TIME");
        if (this.isSystemTimeNotLockedToExternalReference()) {
            sb.append(" UNLOCKED");
        }
        sb.append(":");
        TIME_FORMATTER.setTimeZone(this.getTimeZone());
        sb.append(" ").append(TIME_FORMATTER.format(new Date(this.getSystemTime())));
        sb.append(" LEAP-SECOND CORRECTION:").append(this.getLeapSecondCorrection()).append("mS");
        if (this.isMicroslotsLockedToMinuteRollover()) {
            sb.append(" MICROSLOT-MINUTE ROLLOVER:SLOW");
        } else {
            sb.append(" MICROSLOT-MINUTE ROLLOVER:UNLOCKED");
        }
        return sb.toString();
    }

    public long getSystemTime() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(1, this.getYear());
        cal.set(2, this.getMonth() - 1);
        cal.set(5, this.getDay());
        cal.set(11, this.getHours());
        cal.set(12, this.getMinutes());
        cal.set(14, this.getMilliSeconds());
        return cal.getTimeInMillis();
    }

    public boolean isSystemTimeNotLockedToExternalReference() {
        return this.getMessage().get(29);
    }

    public boolean isMicroslotsLockedToMinuteRollover() {
        return !this.getMessage().get(30);
    }

    public double getLeapSecondCorrection() {
        return (double)this.getMessage().getInt(LEAP_SECOND_CORRECTION) * 2.5;
    }

    public boolean isValidLocalTimeOffset() {
        return !this.getMessage().get(33);
    }

    public TimeZone getTimeZone() {
        if (this.isValidLocalTimeOffset()) {
            int offset = 0;
            offset += this.getMessage().getInt(LOCAL_TIME_OFFSET_HOURS) * 3600000;
            offset = this.getMessage().get(34) ? -offset : (offset += this.getMessage().get(39) ? 1800000 : 0);
            return new SimpleTimeZone(offset, "LOCAL");
        }
        return NO_TIME_ZONE;
    }

    public int getYear() {
        return 2000 + this.getMessage().getInt(YEAR);
    }

    public int getMonth() {
        return this.getMessage().getInt(MONTH);
    }

    public int getDay() {
        return this.getMessage().getInt(DAY);
    }

    public int getHours() {
        return this.getMessage().getInt(HOURS);
    }

    public int getMinutes() {
        return this.getMessage().getInt(MINUTES);
    }

    public int getMilliSeconds() {
        return (int)((double)this.getMicroSlots() * 7.5);
    }

    public int getMicroSlots() {
        return this.getMessage().getInt(MICRO_SLOTS);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

