/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.ISPMessage;
import io.github.dsheirer.module.decode.p25.reference.Capability;
import java.util.ArrayList;
import java.util.List;

public class LocationRegistrationRequest
extends ISPMessage {
    private static final int EMERGENCY_FLAG = 16;
    private static final int[] CAPABILITY = new int[]{17, 18, 19, 20, 21, 22, 23};
    private static final int[] RESERVED = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] LRA = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] GROUP_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Capability mCapability;
    private Identifier mLocationRegistrationArea;
    private Identifier mGroupAddress;
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public LocationRegistrationRequest(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.isEmergency()) {
            sb.append(" EMERGENCY");
        }
        sb.append(" FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getGroupAddress());
        sb.append(" LRA:").append(this.getLocationRegistrationArea());
        sb.append(" CAPABILITY:").append(this.getCapability());
        return sb.toString();
    }

    public boolean isEmergency() {
        return this.getMessage().get(16);
    }

    public Capability getCapability() {
        if (this.mCapability == null) {
            this.mCapability = new Capability(this.getMessage().getInt(CAPABILITY));
        }
        return this.mCapability;
    }

    public Identifier getLocationRegistrationArea() {
        if (this.mLocationRegistrationArea == null) {
            this.mLocationRegistrationArea = APCO25Lra.create(this.getMessage().getInt(LRA));
        }
        return this.mLocationRegistrationArea;
    }

    public Identifier getGroupAddress() {
        if (this.mGroupAddress == null) {
            this.mGroupAddress = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mGroupAddress;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLocationRegistrationArea());
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

