/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import java.util.ArrayList;
import java.util.List;

public class PatchGroupVoiceChannelGrantUpdate
extends OSPMessage
implements IFrequencyBandReceiver {
    public static final int[] FREQUENCY_BAND_1 = new int[]{16, 17, 18, 19};
    public static final int[] CHANNEL_NUMBER_1 = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    public static final int[] PATCH_GROUP_1 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    public static final int[] FREQUENCY_BAND_2 = new int[]{48, 49, 50, 51};
    public static final int[] CHANNEL_NUMBER_2 = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    public static final int[] PATCH_GROUP_2 = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private PatchGroupIdentifier mPatchGroup1;
    private PatchGroupIdentifier mPatchGroup2;
    private APCO25Channel mChannel1;
    private APCO25Channel mChannel2;
    private List<Identifier> mIdentifiers;

    public PatchGroupVoiceChannelGrantUpdate(P25P1DataUnitID dataUnitID, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitID, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" PATCH GRP1:");
        sb.append(this.getPatchGroup1());
        sb.append(" CHAN 1:");
        sb.append(this.getChannel1());
        if (this.hasPatchGroup2()) {
            sb.append(" GRP2:");
            sb.append(this.getPatchGroup2());
            sb.append(" CHAN 2:");
            sb.append(this.getChannel2());
        }
        return sb.toString();
    }

    public boolean hasPatchGroup2() {
        return this.getMessage().getInt(PATCH_GROUP_1) != this.getMessage().getInt(PATCH_GROUP_2) && this.getMessage().getInt(PATCH_GROUP_2) != 0;
    }

    public PatchGroupIdentifier getPatchGroup1() {
        if (this.mPatchGroup1 == null) {
            this.mPatchGroup1 = APCO25PatchGroup.create(new PatchGroup(APCO25Talkgroup.create(this.getMessage().getInt(PATCH_GROUP_1))));
        }
        return this.mPatchGroup1;
    }

    public PatchGroupIdentifier getPatchGroup2() {
        if (this.mPatchGroup2 == null) {
            this.mPatchGroup2 = APCO25PatchGroup.create(new PatchGroup(APCO25Talkgroup.create(this.getMessage().getInt(PATCH_GROUP_2))));
        }
        return this.mPatchGroup2;
    }

    public APCO25Channel getChannel1() {
        if (this.mChannel1 == null) {
            this.mChannel1 = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_1), this.getMessage().getInt(CHANNEL_NUMBER_1));
        }
        return this.mChannel1;
    }

    public APCO25Channel getChannel2() {
        if (this.hasPatchGroup2() && this.mChannel2 == null) {
            this.mChannel2 = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_2), this.getMessage().getInt(CHANNEL_NUMBER_2));
        }
        return this.mChannel2;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel1());
        if (this.hasPatchGroup2()) {
            channels.add(this.getChannel2());
        }
        return channels;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup1());
            if (this.hasPatchGroup2()) {
                this.mIdentifiers.add(this.getPatchGroup2());
            }
        }
        return this.mIdentifiers;
    }
}

