/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCP25;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.P25Utils;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.reference.Direction;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.List;

public abstract class TSBKMessage
extends P25Message {
    private static final int LAST_BLOCK_FLAG = 0;
    private static final int ENCRYPTION_FLAG = 1;
    private static final int[] OPCODE = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private P25P1DataUnitID mDataUnitID;

    public TSBKMessage(P25P1DataUnitID dataUnitID, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(message, nac, timestamp);
        this.mDataUnitID = dataUnitID;
        int errors = CRCP25.correctCCITT80(message, 0, 80);
        if (errors > 1) {
            this.setValid(false);
        }
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return this.mDataUnitID;
    }

    public boolean isEncrypted() {
        return this.getMessage().get(1);
    }

    public boolean isLastBlock() {
        return TSBKMessage.isLastBlock(this.getMessage());
    }

    public static boolean isLastBlock(BinaryMessage binaryMessage) {
        return binaryMessage.get(0);
    }

    public Vendor getVendor() {
        return TSBKMessage.getVendor(this.getMessage());
    }

    public static Vendor getVendor(BinaryMessage binaryMessage) {
        return Vendor.fromValue(binaryMessage.getInt(VENDOR));
    }

    public Opcode getOpcode() {
        return TSBKMessage.getOpcode(this.getMessage(), this.getDirection(), this.getVendor());
    }

    public int getOpcodeNumber() {
        return this.getMessage().getInt(OPCODE);
    }

    public static Opcode getOpcode(BinaryMessage binaryMessage, Direction direction, Vendor vendor) {
        return Opcode.fromValue(binaryMessage.getInt(OPCODE), direction, vendor);
    }

    public abstract Direction getDirection();

    @Override
    public abstract List<Identifier> getIdentifiers();

    @Override
    public String getMessageStub() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessageStub());
        if (this.isValid()) {
            sb.append(" ").append(this.getOpcode().getLabel());
            P25Utils.pad(sb, 30);
            if (this.isEncrypted()) {
                sb.append(" ENCRYPTED");
            }
        } else {
            sb.append("**CRC-FAILED**");
        }
        return sb.toString();
    }
}

