/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.P25Utils;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUHeader;
import io.github.dsheirer.module.decode.p25.reference.ServiceAccessPoint;
import io.github.dsheirer.module.decode.p25.reference.Vendor;

public class UMBTCHeader
extends PDUHeader {
    public static final int[] SAP_ID = new int[]{10, 11, 12, 13, 14, 15};
    public static final int[] PAD_OCTET_COUNT = new int[]{59, 60, 61, 62, 63};
    public static final int[] RESERVED = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    public static final int[] DATA_HEADER_OFFSET = new int[]{74, 75, 76, 77, 78, 79};

    public UMBTCHeader(CorrectedBinaryMessage message, boolean passesCRC) {
        super(message, passesCRC);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("*CRC-FAIL*");
        }
        sb.append("UMBTC");
        Vendor vendor = this.getVendor();
        P25Utils.pad(sb, 22);
        if (vendor != Vendor.STANDARD) {
            sb.append(" VENDOR:").append((Object)this.getVendor());
        }
        sb.append(" HDR:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return ServiceAccessPoint.fromValue(this.getMessage().getInt(SAP_ID));
    }

    public int getPadOctetCount() {
        return this.getMessage().getInt(PAD_OCTET_COUNT);
    }

    public int getDataHeaderOffset() {
        return this.getMessage().getInt(DATA_HEADER_OFFSET);
    }
}

