/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.ActivateTdsContextAccept;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.ActivateTdsContextReject;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.ActivateTdsContextRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.DeActivateTdsContextRequest;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPMessage;
import io.github.dsheirer.module.decode.p25.reference.PDUType;

public class SNDCPMessageFactory {
    public static SNDCPMessage create(BinaryMessage binaryMessage, boolean outbound) {
        PDUType pduType = SNDCPMessage.getPDUType(binaryMessage, outbound);
        switch (pduType) {
            case OUTBOUND_SNDCP_RF_UNCONFIRMED_DATA: 
            case OUTBOUND_SNDCP_RF_CONFIRMED_DATA: 
            case INBOUND_SNDCP_RF_CONFIRMED_DATA: 
            case OUTBOUND_SNDCP_ACTIVATE_TDS_CONTEXT_ACCEPT: {
                return new ActivateTdsContextAccept(binaryMessage, outbound);
            }
            case INBOUND_SNDCP_ACTIVATE_TDS_CONTEXT_REQUEST: {
                return new ActivateTdsContextRequest(binaryMessage, outbound);
            }
            case OUTBOUND_SNDCP_ACTIVATE_TDS_CONTEXT_REJECT: {
                return new ActivateTdsContextReject(binaryMessage, outbound);
            }
            case OUTBOUND_SNDCP_DEACTIVATE_TDS_CONTEXT_REQUEST: {
                return new DeActivateTdsContextRequest(binaryMessage, outbound);
            }
        }
        return new SNDCPMessage(binaryMessage, outbound);
    }
}

