/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class AMBTCTelephoneInterconnectChannelGrant
extends AMBTCMessage
implements IFrequencyBandReceiver {
    private static final int[] HEADER_SERVICE_OPTIONS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] HEADER_RESERVED = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_DOWNLINK_FREQUENCY_BAND = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_DOWNLINK_CHANNEL_NUMBER = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_UPLINK_FREQUENCY_BAND = new int[]{16, 17, 18, 19};
    private static final int[] BLOCK_0_UPLINK_CHANNEL_NUMBER = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] BLOCK_0_CALL_TIMER = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] BLOCK_0_RESERVED = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private VoiceServiceOptions mVoiceServiceOptions;
    private APCO25Channel mChannel;
    private Identifier mAnyAddress;
    private List<Identifier> mIdentifiers;
    private List<IChannelDescriptor> mChannels;

    public AMBTCTelephoneInterconnectChannelGrant(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" ADDR:").append(this.getAnyAddress());
        if (this.getChannel() != null) {
            sb.append(" CHAN:").append(this.getChannel());
        }
        sb.append(" CALL TIMER:").append(this.getCallTimer()).append("ms");
        sb.append(" SERVICE OPTIONS:").append(this.getVoiceServiceOptions());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getHeader().getMessage().getInt(HEADER_SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    public long getCallTimer() {
        if (this.hasDataBlock(0)) {
            return this.getDataBlock(0).getMessage().getInt(BLOCK_0_CALL_TIMER) * 100;
        }
        return 0L;
    }

    public Identifier getAnyAddress() {
        if (this.mAnyAddress == null) {
            this.mAnyAddress = APCO25RadioIdentifier.createFrom(this.getHeader().getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mAnyAddress;
    }

    public boolean isExtendedChannel() {
        return this.hasDataBlock(0) && this.getDataBlock(0).getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER) != this.getDataBlock(0).getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER);
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            if (this.hasDataBlock(0)) {
                UnconfirmedDataBlock block = this.getDataBlock(0);
                this.mChannel = this.isExtendedChannel() ? APCO25ExplicitChannel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER), block.getMessage().getInt(BLOCK_0_UPLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_UPLINK_CHANNEL_NUMBER)) : APCO25Channel.create(block.getMessage().getInt(BLOCK_0_DOWNLINK_FREQUENCY_BAND), block.getMessage().getInt(BLOCK_0_DOWNLINK_CHANNEL_NUMBER));
            }
            if (this.mChannel == null) {
                this.mChannel = APCO25Channel.create(-1, 0);
            }
        }
        return this.mChannel;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getAnyAddress() != null) {
                this.mIdentifiers.add(this.getAnyAddress());
            }
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.mChannels == null) {
            this.mChannels = new ArrayList<IChannelDescriptor>();
            if (this.getChannel() != null) {
                this.mChannels.add(this.getChannel());
            }
        }
        return this.mChannels;
    }
}

