/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25FullyQualifiedRadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25AnnouncementTalkgroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25FullyQualifiedTalkgroupIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCGroupAffiliationResponse
extends AMBTCMessage {
    private static final int[] HEADER_SOURCE_WACN = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_SOURCE_WACN = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_SOURCE_SYSTEM = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_SOURCE_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] BLOCK_0_GROUP_WACN = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
    private static final int[] BLOCK_0_GROUP_SYSTEM = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] BLOCK_0_GROUP_ID = new int[]{72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] BLOCK_0_ANNOUNCEMENT_GROUP_ID = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
    private static final int[] BLOCK_1_ANNOUNCEMENT_GROUP_ID = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private Identifier mTargetAddress;
    private APCO25FullyQualifiedRadioIdentifier mSourceId;
    private APCO25FullyQualifiedTalkgroupIdentifier mGroupId;
    private Identifier mAnnouncementGroupId;
    private List<Identifier> mIdentifiers;

    public AMBTCGroupAffiliationResponse(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.getTargetAddress() != null) {
            sb.append(" TO:").append(this.getTargetAddress());
        }
        if (this.getSourceId() != null) {
            sb.append(" FM:").append(this.getSourceId());
        }
        if (this.getGroupId() != null) {
            sb.append(" GROUP:").append(this.getGroupId());
        }
        if (this.getAnnouncementGroupId() != null) {
            sb.append(" ANNOUNCEMENT GROUP:").append(this.getAnnouncementGroupId());
        }
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null && this.hasDataBlock(0)) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getDataBlock(0).getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public APCO25FullyQualifiedRadioIdentifier getSourceId() {
        if (this.mSourceId == null && this.hasDataBlock(0)) {
            int wacn = this.getHeader().getMessage().getInt(HEADER_SOURCE_WACN);
            wacn <<= 4;
            int system = this.getDataBlock(0).getMessage().getInt(BLOCK_0_SOURCE_SYSTEM);
            int id = this.getDataBlock(0).getMessage().getInt(BLOCK_0_SOURCE_ID);
            this.mSourceId = APCO25FullyQualifiedRadioIdentifier.createFrom(wacn += this.getDataBlock(0).getMessage().getInt(BLOCK_0_SOURCE_WACN), system, id);
        }
        return this.mSourceId;
    }

    public APCO25FullyQualifiedTalkgroupIdentifier getGroupId() {
        if (this.mGroupId == null && this.hasDataBlock(0)) {
            int wacn = this.getDataBlock(0).getMessage().getInt(BLOCK_0_GROUP_WACN);
            int system = this.getDataBlock(0).getMessage().getInt(BLOCK_0_GROUP_SYSTEM);
            int id = this.getDataBlock(0).getMessage().getInt(BLOCK_0_GROUP_ID);
            this.mGroupId = APCO25FullyQualifiedTalkgroupIdentifier.createAny(wacn, system, id);
        }
        return this.mGroupId;
    }

    public Identifier getAnnouncementGroupId() {
        if (this.mAnnouncementGroupId == null && this.hasDataBlock(0) && this.hasDataBlock(1)) {
            int id = this.getDataBlock(0).getMessage().getInt(BLOCK_0_ANNOUNCEMENT_GROUP_ID);
            id <<= 8;
            this.mAnnouncementGroupId = APCO25AnnouncementTalkgroup.create(id += this.getDataBlock(1).getMessage().getInt(BLOCK_1_ANNOUNCEMENT_GROUP_ID));
        }
        return this.mAnnouncementGroupId;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getTargetAddress() != null) {
                this.mIdentifiers.add(this.getTargetAddress());
            }
            if (this.getSourceId() != null) {
                this.mIdentifiers.add(this.getSourceId());
            }
            if (this.getGroupId() != null) {
                this.mIdentifiers.add(this.getGroupId());
            }
            if (this.getAnnouncementGroupId() != null) {
                this.mIdentifiers.add(this.getAnnouncementGroupId());
            }
        }
        return this.mIdentifiers;
    }
}

