/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.status.APCO25UnitStatus;
import io.github.dsheirer.module.decode.p25.identifier.status.APCO25UserStatus;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCStatusUpdateRequest
extends AMBTCMessage {
    private static final int[] HEADER_UNIT_STATUS = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] HEADER_USER_STATUS = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static final int[] BLOCK_0_SYSTEM = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] BLOCK_0_TARGET_ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] BLOCK_0_RESERVED = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private Identifier mUnitStatus;
    private Identifier mUserStatus;
    private Identifier mWacn;
    private Identifier mSystem;
    private Identifier mSourceAddress;
    private Identifier mTargetId;
    private List<Identifier> mIdentifiers;

    public AMBTCStatusUpdateRequest(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" FM:").append(this.getSourceAddress());
        if (this.getTargetId() != null) {
            sb.append(" TO:").append(this.getTargetId());
        }
        if (this.getWacn() != null) {
            sb.append(" WACN:").append(this.getWacn());
        }
        if (this.getSystem() != null) {
            sb.append(" SYSTEM:").append(this.getSystem());
        }
        sb.append(" UNIT STATUS:").append(this.getUnitStatus());
        sb.append(" USER STATUS:").append(this.getUserStatus());
        return sb.toString();
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getHeader().getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mSourceAddress;
    }

    public Identifier getUnitStatus() {
        if (this.mUnitStatus == null) {
            this.mUnitStatus = APCO25UnitStatus.create(this.getHeader().getMessage().getInt(HEADER_UNIT_STATUS));
        }
        return this.mUnitStatus;
    }

    public Identifier getUserStatus() {
        if (this.mUserStatus == null) {
            this.mUserStatus = APCO25UserStatus.create(this.getHeader().getMessage().getInt(HEADER_USER_STATUS));
        }
        return this.mUserStatus;
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            this.mWacn = APCO25Wacn.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null && this.hasDataBlock(0)) {
            this.mSystem = APCO25System.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getTargetId() {
        if (this.mTargetId == null && this.hasDataBlock(0)) {
            this.mTargetId = APCO25RadioIdentifier.createTo(this.getDataBlock(0).getMessage().getInt(BLOCK_0_TARGET_ID));
        }
        return this.mTargetId;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getSourceAddress() != null) {
                this.mIdentifiers.add(this.getSourceAddress());
            }
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
            if (this.getTargetId() != null) {
                this.mIdentifiers.add(this.getTargetId());
            }
        }
        return this.mIdentifiers;
    }
}

