/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCGroupAffiliationRequest
extends AMBTCMessage {
    private static final int[] HEADER_WACN = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_SYSTEM = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_GROUP_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] RESERVED = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private Identifier mWacn;
    private Identifier mSystem;
    private Identifier mGroupId;
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public AMBTCGroupAffiliationRequest(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" FM:").append(this.getSourceAddress());
        if (this.getSourceAddress() != null) {
            sb.append(" TO:").append(this.getGroupId());
        }
        if (this.getWacn() != null) {
            sb.append(" WACN:").append(this.getWacn());
        }
        if (this.getSystem() != null) {
            sb.append(" SYSTEM:").append(this.getSystem());
        }
        return sb.toString();
    }

    public Identifier getGroupId() {
        if (this.mGroupId == null) {
            this.mGroupId = APCO25Talkgroup.create(this.getHeader().getMessage().getInt(BLOCK_0_GROUP_ID));
        }
        return this.mGroupId;
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            int value = this.getHeader().getMessage().getInt(HEADER_WACN);
            value <<= 4;
            this.mWacn = APCO25Wacn.create(value += this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null && this.hasDataBlock(0)) {
            this.mSystem = APCO25System.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null && this.hasDataBlock(0)) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getDataBlock(0).getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getSourceAddress() != null) {
                this.mIdentifiers.add(this.getSourceAddress());
            }
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
            if (this.getGroupId() != null) {
                this.mIdentifiers.add(this.getGroupId());
            }
        }
        return this.mIdentifiers;
    }
}

