/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.ldu;

import io.github.dsheirer.audio.codec.mbe.IEncryptionSyncParameters;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.encryption.EncryptionKey;
import io.github.dsheirer.identifier.encryption.EncryptionKeyIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.encryption.APCO25EncryptionKey;
import java.util.ArrayList;
import java.util.List;

public class EncryptionSyncParameters
implements IEncryptionSyncParameters {
    private static final int[] MESSAGE_INDICATOR_1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] MESSAGE_INDICATOR_2 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] MESSAGE_INDICATOR_3 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MESSAGE_INDICATOR_4 = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] MESSAGE_INDICATOR_5 = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] MESSAGE_INDICATOR_6 = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] MESSAGE_INDICATOR_7 = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] MESSAGE_INDICATOR_8 = new int[]{56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] MESSAGE_INDICATOR_9 = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] ALGORITHM_ID = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] KEY_ID = new int[]{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95};
    private BinaryMessage mMessage;
    private boolean mValid = true;
    private String mMessageIndicator;
    private EncryptionKeyIdentifier mEncryptionKey;
    private List<Identifier> mIdentifiers;

    public EncryptionSyncParameters(BinaryMessage message) {
        this.mMessage = message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isValid()) {
            if (this.isEncryptedAudio()) {
                sb.append(this.getEncryptionKey());
                sb.append(" MSG INDICATOR:").append(this.getMessageIndicator());
            } else {
                sb.append("UNENCRYPTED       ");
            }
        } else {
            sb.append("***CRC-FAIL***");
        }
        return sb.toString();
    }

    private BinaryMessage getMessage() {
        return this.mMessage;
    }

    public boolean isValid() {
        return this.mValid;
    }

    public void setValid(boolean valid) {
        this.mValid = valid;
    }

    @Override
    public String getMessageIndicator() {
        if (this.mMessageIndicator == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_1, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_2, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_3, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_4, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_5, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_6, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_7, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_8, 2));
            sb.append(this.getMessage().getHex(MESSAGE_INDICATOR_9, 2));
            this.mMessageIndicator = sb.toString();
        }
        return this.mMessageIndicator;
    }

    @Override
    public EncryptionKeyIdentifier getEncryptionKey() {
        if (this.mEncryptionKey == null) {
            this.mEncryptionKey = EncryptionKeyIdentifier.create(APCO25EncryptionKey.create(this.getMessage().getInt(ALGORITHM_ID), this.getMessage().getInt(KEY_ID)));
        }
        return this.mEncryptionKey;
    }

    public boolean isEncryptedAudio() {
        return ((EncryptionKey)this.getEncryptionKey().getValue()).isEncrypted();
    }

    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.isEncryptedAudio()) {
                this.mIdentifiers.add(this.getEncryptionKey());
            }
        }
        return this.mIdentifiers;
    }
}

