/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class LCGroupVoiceChannelUpdateExplicit
extends LinkControlWord
implements IFrequencyBandReceiver {
    public static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    public static final int[] GROUP_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    public static final int[] DOWNLINK_FREQUENCY_BAND = new int[]{40, 41, 42, 43};
    public static final int[] DOWNLINK_CHANNEL = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    public static final int[] UPLINK_FREQUENCY_BAND = new int[]{56, 57, 58, 59};
    public static final int[] UPLINK_CHANNEL = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private VoiceServiceOptions mVoiceServiceOptions;
    private IChannelDescriptor mChannel;
    private List<IChannelDescriptor> mChannels;
    private Identifier mTalkgroup;
    private List<Identifier> mIdentifiers;

    public LCGroupVoiceChannelUpdateExplicit(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TALKGROUP:").append(this.getGroupAddress());
        sb.append(" ").append(this.getChannel());
        sb.append(" ").append(this.getVoiceServiceOptions());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddress());
        }
        return this.mIdentifiers;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25ExplicitChannel.create(this.getMessage().getInt(DOWNLINK_FREQUENCY_BAND), this.getMessage().getInt(DOWNLINK_CHANNEL), this.getMessage().getInt(UPLINK_FREQUENCY_BAND), this.getMessage().getInt(UPLINK_CHANNEL));
        }
        return this.mChannel;
    }

    public Identifier getGroupAddress() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS));
        }
        return this.mTalkgroup;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

