/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import java.util.ArrayList;
import java.util.List;

public class LCGroupVoiceChannelUpdate
extends LinkControlWord
implements IFrequencyBandReceiver {
    public static final int[] FREQUENCY_BAND_A = new int[]{8, 9, 10, 11};
    public static final int[] CHANNEL_A = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    public static final int[] GROUP_ADDRESS_A = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    public static final int[] FREQUENCY_BAND_B = new int[]{40, 41, 42, 43};
    public static final int[] CHANNEL_B = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    public static final int[] GROUP_ADDRESS_B = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private IChannelDescriptor mChannelA;
    private IChannelDescriptor mChannelB;
    private Identifier mTalkgroupA;
    private Identifier mTalkgroupB;
    private List<Identifier> mIdentifiers;

    public LCGroupVoiceChannelUpdate(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" TALKGROUP A:").append(this.getGroupAddressA());
        sb.append(" CHAN A:").append(this.getChannelA());
        if (this.hasChannelB()) {
            sb.append(" TALKGROUP B:").append(this.getGroupAddressB());
            sb.append(" CHAN B:").append(this.getChannelB());
        }
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddressA());
            if (this.hasChannelB()) {
                this.mIdentifiers.add(this.getGroupAddressB());
            }
        }
        return this.mIdentifiers;
    }

    public IChannelDescriptor getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_A), this.getMessage().getInt(CHANNEL_A));
        }
        return this.mChannelA;
    }

    public IChannelDescriptor getChannelB() {
        if (this.mChannelB == null) {
            this.mChannelB = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_B), this.getMessage().getInt(CHANNEL_B));
        }
        return this.mChannelB;
    }

    public boolean hasChannelB() {
        return this.getMessage().getInt(CHANNEL_B) != 0 && this.getMessage().getInt(GROUP_ADDRESS_A) != this.getMessage().getInt(GROUP_ADDRESS_B);
    }

    public Identifier getGroupAddressA() {
        if (this.mTalkgroupA == null) {
            this.mTalkgroupA = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_A));
        }
        return this.mTalkgroupA;
    }

    public Identifier getGroupAddressB() {
        if (this.mTalkgroupB == null) {
            this.mTalkgroupB = APCO25Talkgroup.create(this.getMessage().getInt(GROUP_ADDRESS_B));
        }
        return this.mTalkgroupB;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        channels.add(this.getChannelB());
        return channels;
    }
}

