/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import java.util.ArrayList;
import java.util.List;

public class LCCallTermination
extends LinkControlWord {
    private static final int MOTOROLA_SYSTEM_CONTROLLER = 0xFFFFFD;
    private static final int HARRIS_SYSTEM_CONTROLLER = 0;
    private static final int[] ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private Identifier mAddress;
    private List<Identifier> mIdentifiers;

    public LCCallTermination(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" BY:").append(this.getAddress());
        return sb.toString();
    }

    public Identifier getAddress() {
        if (this.mAddress == null) {
            this.mAddress = APCO25Talkgroup.create(this.getMessage().getInt(ADDRESS));
        }
        return this.mAddress;
    }

    public boolean isNetworkCommandedTeardown() {
        int address = this.getMessage().getInt(ADDRESS);
        return address == 0xFFFFFD || address == 0;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getAddress());
        }
        return this.mIdentifiers;
    }
}

