/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc.UMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.TSBKMessage;
import java.util.Collection;
import java.util.function.Function;

public class TrunkingOpcodeMessageFilter
extends Filter<IMessage, Opcode> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);
    private Collection<Opcode> mOpcodes;

    public TrunkingOpcodeMessageFilter(String name, Collection<Opcode> opcodes) {
        super(name);
        this.mOpcodes = opcodes;
        for (Opcode opcode : opcodes) {
            this.add(new FilterElement<Opcode>(opcode));
        }
    }

    @Override
    public Function<IMessage, Opcode> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, Opcode> {
        private KeyExtractor(TrunkingOpcodeMessageFilter trunkingOpcodeMessageFilter) {
        }

        @Override
        public Opcode apply(IMessage message) {
            if (message instanceof TSBKMessage) {
                TSBKMessage tsbk = (TSBKMessage)message;
                return tsbk.getOpcode();
            }
            if (message instanceof AMBTCMessage) {
                AMBTCMessage ambtc = (AMBTCMessage)message;
                return ambtc.getHeader().getOpcode();
            }
            if (message instanceof UMBTCMessage) {
                UMBTCMessage umbtc = (UMBTCMessage)message;
                return umbtc.getOpcode();
            }
            return null;
        }
    }
}

