/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.filter.TDUMessageFilter;
import io.github.dsheirer.module.decode.p25.phase1.message.filter.TerminatorMessageFilter;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlOpcode;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDULinkControlMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDUMessage;
import java.util.ArrayList;

public class TerminatorMessageFilterSet
extends FilterSet<IMessage> {
    public TerminatorMessageFilterSet() {
        super("Terminator Messages");
        this.addFilter(new TDUMessageFilter());
        this.addFilter(new TerminatorMessageFilter("Command/Status", LinkControlOpcode.COMMAND_STATUS_OPCODES));
        this.addFilter(new TerminatorMessageFilter("Network/Channel", LinkControlOpcode.NETWORK_OPCODES));
        this.addFilter(new TerminatorMessageFilter("Voice", LinkControlOpcode.VOICE_OPCODES));
        this.addFilter(new TerminatorMessageFilter("L3Harris", LinkControlOpcode.L3HARRIS_OPCODES));
        this.addFilter(new TerminatorMessageFilter("Motorola", LinkControlOpcode.MOTOROLA_OPCODES));
        ArrayList<LinkControlOpcode> others = new ArrayList<LinkControlOpcode>();
        for (LinkControlOpcode opcode : LinkControlOpcode.values()) {
            if (opcode.isGrouped()) continue;
            others.add(opcode);
        }
        this.addFilter(new TerminatorMessageFilter("Other/Reserved", others));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return (message instanceof TDUMessage || message instanceof TDULinkControlMessage) && super.canProcess(message);
    }
}

