/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import io.github.dsheirer.module.decode.ip.icmp.ICMPPacket;
import io.github.dsheirer.module.decode.ip.ipv4.IPV4Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPPacket;
import io.github.dsheirer.module.decode.ip.udp.UDPPacket;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.PacketMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp.SNDCPPacketMessage;
import java.util.function.Function;

public class PacketMessageFilter
extends Filter<IMessage, String> {
    private static final String KEY_CELLOCATOR = "Cellocator Packet";
    private static final String KEY_IPV4_OTHER = "IPV4 Other Packet";
    private static final String KEY_IPV4_UDP_ICMP = "IPV4 UDP/IP ICMP Packet";
    private static final String KEY_IPV4_UDP_OTHER = "IPV4 UDP/IP Other Packet";
    private static final String KEY_MOTOROLA_ARS = "Motorola Registration (ARS) Packet";
    private static final String KEY_MOTOROLA_LRRP = "Motorola Location Report (LRRP) Packet";
    private static final String KEY_MOTOROLA_XCMP = "Motorola Extensible (XCMP) Packet";
    private static final String KEY_SNDCP = "SNDCP Data Packet";
    private static final String KEY_UNKNOWN = "Unknown Packet";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public PacketMessageFilter() {
        super("Packet Messages");
        this.add(new FilterElement<String>(KEY_CELLOCATOR));
        this.add(new FilterElement<String>(KEY_IPV4_OTHER));
        this.add(new FilterElement<String>(KEY_IPV4_UDP_ICMP));
        this.add(new FilterElement<String>(KEY_IPV4_UDP_OTHER));
        this.add(new FilterElement<String>(KEY_MOTOROLA_ARS));
        this.add(new FilterElement<String>(KEY_MOTOROLA_LRRP));
        this.add(new FilterElement<String>(KEY_MOTOROLA_XCMP));
        this.add(new FilterElement<String>(KEY_SNDCP));
        this.add(new FilterElement<String>(KEY_UNKNOWN));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof PacketMessage && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(PacketMessageFilter packetMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof PacketMessage) {
                PacketMessage packetMessage = (PacketMessage)message;
                IPacket packet = packetMessage.getPacket();
                if (packet instanceof MCGPPacket) {
                    return PacketMessageFilter.KEY_CELLOCATOR;
                }
                if (packet instanceof ICMPPacket) {
                    return PacketMessageFilter.KEY_IPV4_UDP_ICMP;
                }
                if (packet instanceof UDPPacket) {
                    return PacketMessageFilter.KEY_IPV4_UDP_OTHER;
                }
                if (packet instanceof IPV4Packet) {
                    return PacketMessageFilter.KEY_IPV4_OTHER;
                }
                if (packet instanceof SNDCPPacketMessage) {
                    return PacketMessageFilter.KEY_SNDCP;
                }
                if (packet instanceof ARSPacket) {
                    return PacketMessageFilter.KEY_MOTOROLA_ARS;
                }
                if (packet instanceof LRRPPacket) {
                    return PacketMessageFilter.KEY_MOTOROLA_LRRP;
                }
                if (packet instanceof XCMPPacket) {
                    return PacketMessageFilter.KEY_MOTOROLA_XCMP;
                }
                return PacketMessageFilter.KEY_UNKNOWN;
            }
            return null;
        }
    }
}

