/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Nac;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.protocol.Protocol;

public abstract class P25Message
extends Message {
    private CorrectedBinaryMessage mMessage;
    private boolean mValid = true;
    private Identifier mNAC;

    public P25Message(CorrectedBinaryMessage message, int nac, long timestamp) {
        super(timestamp);
        this.mMessage = message;
        this.mNAC = APCO25Nac.create(nac);
    }

    public P25Message(CorrectedBinaryMessage message, int nac) {
        this(message, nac, System.currentTimeMillis());
    }

    protected P25Message(int nac, long timestamp) {
        super(timestamp);
        this.mNAC = APCO25Nac.create(nac);
    }

    protected void setMessage(CorrectedBinaryMessage message) {
        this.mMessage = message;
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public Identifier getNAC() {
        return this.mNAC;
    }

    public abstract P25P1DataUnitID getDUID();

    @Override
    public String toString() {
        return this.getMessageStub();
    }

    protected String getMessageStub() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAC:");
        sb.append(this.getNAC());
        sb.append(" ");
        sb.append(this.getDUID().getLabel());
        return sb.toString();
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.APCO25;
    }

    @Override
    public boolean isValid() {
        return this.mValid;
    }

    protected void setValid(boolean valid) {
        this.mValid = valid;
    }

    public static enum SessionMode {
        PACKET,
        CIRCUIT;

    }

    public static enum DuplexMode {
        HALF,
        FULL;

    }
}

