/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.identifier.channel;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.protocol.Protocol;
import java.text.DecimalFormat;

public class StandardChannel
implements IChannelDescriptor {
    private static final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("0.000");
    private long mFrequency;

    public StandardChannel(long frequency) {
        this.mFrequency = frequency;
    }

    @Override
    public long getDownlinkFrequency() {
        return this.mFrequency;
    }

    @Override
    public long getUplinkFrequency() {
        return this.mFrequency;
    }

    @Override
    public int[] getFrequencyBandIdentifiers() {
        return new int[0];
    }

    @Override
    public void setFrequencyBand(IFrequencyBand bandIdentifier) {
    }

    @Override
    public boolean isTDMAChannel() {
        return false;
    }

    @Override
    public int getTimeslotCount() {
        return 0;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.UNKNOWN;
    }

    public String toString() {
        return FREQUENCY_FORMATTER.format((double)this.mFrequency / 1000000.0) + " MHz";
    }
}

