/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.identifier.channel;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.protocol.Protocol;

public class APCO25Channel
extends Identifier<P25Channel>
implements IChannelDescriptor,
Comparable<IChannelDescriptor> {
    public APCO25Channel(P25Channel p25Channel) {
        super(p25Channel, IdentifierClass.NETWORK, Form.CHANNEL, Role.BROADCAST);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.APCO25;
    }

    @Override
    public int[] getFrequencyBandIdentifiers() {
        return ((P25Channel)this.getValue()).getFrequencyBandIdentifiers();
    }

    @Override
    public int getTimeslotCount() {
        return ((P25Channel)this.getValue()).getTimeslotCount();
    }

    @Override
    public boolean isTDMAChannel() {
        return ((P25Channel)this.getValue()).isTDMAChannel();
    }

    @Override
    public void setFrequencyBand(IFrequencyBand bandIdentifier) {
        ((P25Channel)this.getValue()).setFrequencyBand(bandIdentifier);
    }

    @Override
    public long getDownlinkFrequency() {
        return ((P25Channel)this.getValue()).getDownlinkFrequency();
    }

    @Override
    public long getUplinkFrequency() {
        return ((P25Channel)this.getValue()).getUplinkFrequency();
    }

    public int getTimeslot() {
        return ((P25Channel)this.getValue()).getTimeslot();
    }

    public static APCO25Channel create(int frequencyBand, int channelNumber) {
        return new APCO25Channel(new P25Channel(frequencyBand, channelNumber));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof APCO25Channel) || ((APCO25Channel)o).getValue() == null) {
            return false;
        }
        return ((P25Channel)this.getValue()).equals(((APCO25Channel)o).getValue());
    }

    @Override
    public int hashCode() {
        return ((P25Channel)this.getValue()).hashCode();
    }

    @Override
    public int compareTo(IChannelDescriptor o) {
        if (o == null) {
            return -1;
        }
        return Long.compare(this.getDownlinkFrequency(), o.getDownlinkFrequency());
    }
}

