/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.audio;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.codec.mbe.AmbeAudioModule;
import io.github.dsheirer.audio.squelch.SquelchState;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.IdentifierUpdateProvider;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.tone.AmbeTone;
import io.github.dsheirer.identifier.tone.P25ToneIdentifier;
import io.github.dsheirer.identifier.tone.Tone;
import io.github.dsheirer.identifier.tone.ToneIdentifier;
import io.github.dsheirer.identifier.tone.ToneIdentifierMessage;
import io.github.dsheirer.identifier.tone.ToneSequence;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageProvider;
import io.github.dsheirer.module.decode.p25.phase2.message.EncryptionSynchronizationSequence;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.PushToTalk;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import jmbe.iface.IAudioWithMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2AudioModule
extends AmbeAudioModule
implements IdentifierUpdateProvider,
IMessageProvider {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2AudioModule.class);
    private Listener<IdentifierUpdateNotification> mIdentifierUpdateNotificationListener;
    private SquelchStateListener mSquelchStateListener = new SquelchStateListener();
    private ToneMetadataProcessor mToneMetadataProcessor = new ToneMetadataProcessor(this);
    private Queue<AbstractVoiceTimeslot> mQueuedAudioTimeslots = new ArrayDeque<AbstractVoiceTimeslot>();
    private boolean mEncryptedCallStateEstablished = false;
    private boolean mEncryptedCall = false;
    private Listener<IMessage> mMessageListener;

    public P25P2AudioModule(UserPreferences userPreferences, int timeslot, AliasList aliasList) {
        super(userPreferences, aliasList, timeslot);
    }

    @Override
    public Listener<SquelchStateEvent> getSquelchStateListener() {
        return this.mSquelchStateListener;
    }

    @Override
    public void reset() {
        this.mIdentifierCollection.remove(Role.FROM);
        this.mToneMetadataProcessor.reset();
        this.mQueuedAudioTimeslots.clear();
        this.mEncryptedCallStateEstablished = false;
        this.mEncryptedCall = false;
    }

    @Override
    public void start() {
        this.reset();
    }

    @Override
    public void receive(IMessage message) {
        if (message.getTimeslot() == this.getTimeslot()) {
            if (message instanceof AbstractVoiceTimeslot) {
                AbstractVoiceTimeslot abstractVoiceTimeslot = (AbstractVoiceTimeslot)message;
                if (this.mEncryptedCallStateEstablished) {
                    if (!this.mEncryptedCall) {
                        this.processAudio(abstractVoiceTimeslot.getVoiceFrames(), message.getTimestamp());
                    }
                } else {
                    this.mQueuedAudioTimeslots.offer(abstractVoiceTimeslot);
                }
            } else if (message instanceof PushToTalk && message.isValid()) {
                this.mEncryptedCallStateEstablished = true;
                this.mEncryptedCall = ((PushToTalk)((Object)message)).isEncrypted();
            } else if (message instanceof EncryptionSynchronizationSequence && message.isValid()) {
                this.mEncryptedCallStateEstablished = true;
                this.mEncryptedCall = ((EncryptionSynchronizationSequence)message).isEncrypted();
                this.processPendingVoiceTimeslots();
            }
        }
    }

    private void processPendingVoiceTimeslots() {
        AbstractVoiceTimeslot timeslot = this.mQueuedAudioTimeslots.poll();
        while (timeslot != null) {
            this.receive(timeslot);
            timeslot = this.mQueuedAudioTimeslots.poll();
        }
    }

    private void processAudio(List<BinaryMessage> voiceFrames, long timestamp) {
        if (this.hasAudioCodec()) {
            for (BinaryMessage voiceFrame : voiceFrames) {
                byte[] voiceFrameBytes = voiceFrame.getBytes();
                try {
                    IAudioWithMetadata audioWithMetadata = this.getAudioCodec().getAudioWithMetadata(voiceFrameBytes);
                    this.addAudio(audioWithMetadata.getAudio());
                    this.processMetadata(audioWithMetadata, timestamp);
                }
                catch (Exception e) {
                    mLog.error("Error synthesizing AMBE audio - continuing [" + e.getLocalizedMessage() + "]");
                }
            }
        }
    }

    private void processMetadata(IAudioWithMetadata audioWithMetadata, long timestamp) {
        if (audioWithMetadata.hasMetadata()) {
            for (Map.Entry entry : audioWithMetadata.getMetadata().entrySet()) {
                ToneIdentifier toneIdentifier = this.mToneMetadataProcessor.process((String)entry.getKey(), (String)entry.getValue());
                if (toneIdentifier == null) continue;
                this.broadcast(toneIdentifier, timestamp);
            }
        } else {
            this.mToneMetadataProcessor.closeMetadata();
        }
    }

    private void broadcast(ToneIdentifier identifier, long timestamp) {
        if (this.mIdentifierUpdateNotificationListener != null) {
            this.mIdentifierUpdateNotificationListener.receive(new IdentifierUpdateNotification(identifier, IdentifierUpdateNotification.Operation.ADD, this.getTimeslot()));
        }
        if (this.mMessageListener != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("P25.2 Timeslot ");
            sb.append(this.getTimeslot());
            sb.append("Audio Tone Sequence Decoded: ");
            sb.append(identifier.toString());
            this.mMessageListener.receive(new ToneIdentifierMessage(Protocol.APCO25_PHASE2, this.getTimeslot(), timestamp, identifier, sb.toString()));
        }
    }

    @Override
    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.mIdentifierUpdateNotificationListener = listener;
    }

    @Override
    public void removeIdentifierUpdateListener() {
        this.mIdentifierUpdateNotificationListener = null;
    }

    @Override
    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    @Override
    public void removeMessageListener() {
        this.mMessageListener = null;
    }

    public class SquelchStateListener
    implements Listener<SquelchStateEvent> {
        @Override
        public void receive(SquelchStateEvent event) {
            if (event.getTimeslot() == P25P2AudioModule.this.getTimeslot() && event.getSquelchState() == SquelchState.SQUELCH) {
                P25P2AudioModule.this.closeAudioSegment();
                P25P2AudioModule.this.reset();
            }
        }
    }

    public class ToneMetadataProcessor {
        private List<Tone> mTones = new ArrayList<Tone>();
        private Tone mCurrentTone;

        public ToneMetadataProcessor(P25P2AudioModule this$0) {
        }

        public void reset() {
            this.mTones.clear();
        }

        public ToneIdentifier process(String type, String value) {
            if (type == null || value == null) {
                return null;
            }
            AmbeTone tone = AmbeTone.fromValues(type, value);
            if (tone == AmbeTone.INVALID) {
                return null;
            }
            if (this.mCurrentTone == null || this.mCurrentTone.getAmbeTone() != tone) {
                this.mCurrentTone = new Tone(tone);
                this.mTones.add(this.mCurrentTone);
            }
            this.mCurrentTone.incrementDuration();
            return P25ToneIdentifier.create(new ToneSequence(new ArrayList<Tone>(this.mTones)));
        }

        public void closeMetadata() {
            this.mCurrentTone = null;
        }
    }
}

