/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.audio;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.audio.codec.mbe.ImbeAudioModule;
import io.github.dsheirer.audio.squelch.SquelchState;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.dsp.gain.NonClippingGain;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.hdu.HDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU1Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU2Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDUMessage;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.sample.Listener;

public class P25P1AudioModule
extends ImbeAudioModule {
    private boolean mEncryptedCall = false;
    private boolean mEncryptedCallStateEstablished = false;
    private SquelchStateListener mSquelchStateListener = new SquelchStateListener();
    private NonClippingGain mGain = new NonClippingGain(5.0f, 0.95f);
    private LDU1Message mCachedLDU1Message = null;

    public P25P1AudioModule(UserPreferences userPreferences, AliasList aliasList) {
        super(userPreferences, aliasList);
    }

    @Override
    protected int getTimeslot() {
        return 0;
    }

    @Override
    public Listener<SquelchStateEvent> getSquelchStateListener() {
        return this.mSquelchStateListener;
    }

    @Override
    public void reset() {
        this.getIdentifierCollection().clear();
    }

    @Override
    public void start() {
    }

    @Override
    public void receive(IMessage message) {
        if (this.hasAudioCodec()) {
            if (this.mEncryptedCallStateEstablished) {
                if (message instanceof LDUMessage) {
                    this.processAudio((LDUMessage)message);
                }
            } else if (message instanceof HDUMessage) {
                this.mEncryptedCallStateEstablished = true;
                this.mEncryptedCall = ((HDUMessage)message).getHeaderData().isEncryptedAudio();
            } else if (message instanceof LDU1Message) {
                this.mCachedLDU1Message = (LDU1Message)message;
            } else if (message instanceof LDU2Message) {
                this.mEncryptedCallStateEstablished = true;
                LDU2Message ldu2 = (LDU2Message)message;
                this.mEncryptedCall = ldu2.getEncryptionSyncParameters().isEncryptedAudio();
                if (this.mCachedLDU1Message != null) {
                    this.processAudio(this.mCachedLDU1Message);
                    this.mCachedLDU1Message = null;
                }
                this.processAudio(ldu2);
            }
        }
    }

    private void processAudio(LDUMessage ldu) {
        if (!this.mEncryptedCall) {
            for (byte[] frame : ldu.getIMBEFrames()) {
                float[] audio = this.getAudioCodec().getAudio(frame);
                audio = this.mGain.apply(audio);
                this.addAudio(audio);
            }
        }
    }

    public class SquelchStateListener
    implements Listener<SquelchStateEvent> {
        @Override
        public void receive(SquelchStateEvent event) {
            if (event.getSquelchState() == SquelchState.SQUELCH) {
                P25P1AudioModule.this.closeAudioSegment();
                P25P1AudioModule.this.mEncryptedCallStateEstablished = false;
                P25P1AudioModule.this.mEncryptedCall = false;
                P25P1AudioModule.this.mCachedLDU1Message = null;
            }
        }
    }
}

