/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.config.WithCallTimeout;
import io.github.dsheirer.module.decode.mpt1327.Sync;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;

public class DecodeConfigMPT1327
extends DecodeConfiguration
implements WithCallTimeout {
    public static final int CHANNEL_ROTATION_DELAY_MINIMUM_MS = 500;
    public static final int CHANNEL_ROTATION_DELAY_DEFAULT_MS = 500;
    public static final int CHANNEL_ROTATION_DELAY_MAXIMUM_MS = 2000;
    private String mChannelMapName;
    private Sync mSync = Sync.NORMAL;
    private int mCallTimeoutSeconds = 45;
    private int mTrafficChannelPoolSize = 3;

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public DecoderType getDecoderType() {
        return DecoderType.MPT1327;
    }

    @JacksonXmlProperty(isAttribute=false, localName="channelMapName")
    public String getChannelMapName() {
        return this.mChannelMapName;
    }

    public void setChannelMapName(String name) {
        this.mChannelMapName = name;
    }

    @JacksonXmlProperty(isAttribute=true, localName="sync")
    public Sync getSync() {
        return this.mSync;
    }

    public void setSync(Sync sync) {
        this.mSync = sync;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="call_timeout")
    public int getCallTimeoutSeconds() {
        return this.mCallTimeoutSeconds;
    }

    public void setCallTimeoutSeconds(int timeout) {
        this.mCallTimeoutSeconds = 1 <= timeout && timeout <= 180 ? timeout : 45;
    }

    @JacksonXmlProperty(isAttribute=true, localName="traffic_channel_pool_size")
    public int getTrafficChannelPoolSize() {
        return this.mTrafficChannelPoolSize;
    }

    public void setTrafficChannelPoolSize(int size) {
        this.mTrafficChannelPoolSize = size;
    }

    @Override
    @JsonIgnore
    public ChannelSpecification getChannelSpecification() {
        return new ChannelSpecification(25000.0, 12500, 6000.0, 7000.0);
    }
}

