/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mdc1200;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.mdc1200.MDCMessage;
import io.github.dsheirer.module.decode.mdc1200.MDCMessageType;
import java.util.function.Function;

public class MDCMessageFilter
extends Filter<IMessage, MDCMessageType> {
    private final KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public MDCMessageFilter() {
        super("MDC-1200 Messages");
        for (MDCMessageType type : MDCMessageType.values()) {
            this.add(new FilterElement<MDCMessageType>(type));
        }
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof MDCMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, MDCMessageType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, MDCMessageType> {
        private KeyExtractor(MDCMessageFilter mDCMessageFilter) {
        }

        @Override
        public MDCMessageType apply(IMessage message) {
            if (message instanceof MDCMessage) {
                MDCMessage mdc = (MDCMessage)message;
                return mdc.getMessageType();
            }
            return null;
        }
    }
}

