/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mdc1200;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.mdc1200.MDCDecodeEvent;
import io.github.dsheirer.module.decode.mdc1200.MDCMessage;
import io.github.dsheirer.module.decode.mdc1200.MDCMessageType;
import io.github.dsheirer.module.decode.mdc1200.identifier.MDC1200Identifier;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MDCDecoderState
extends DecoderState {
    private Set<MDC1200Identifier> mIdents = new TreeSet<MDC1200Identifier>();
    private Set<MDC1200Identifier> mEmergencyIdents = new TreeSet<MDC1200Identifier>();

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.MDC1200;
    }

    @Override
    public void reset() {
        super.reset();
        this.mIdents.clear();
        this.mEmergencyIdents.clear();
        this.resetState();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    public void receive(IMessage message) {
        if (message instanceof MDCMessage) {
            MDCMessage mdc = (MDCMessage)message;
            this.mIdents.add(mdc.getFromIdentifier());
            if (mdc.isEmergency()) {
                this.mEmergencyIdents.add(mdc.getFromIdentifier());
            }
            MDCMessageType type = mdc.getMessageType();
            StringBuilder sb = new StringBuilder();
            sb.append("OPCODE ");
            sb.append(mdc.getOpcode());
            if (mdc.isBOT()) {
                sb.append(" TYPE:BOT");
            }
            if (mdc.isEOT()) {
                sb.append(" TYPE:EOT");
            }
            MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            ic.remove(IdentifierClass.USER);
            ic.update(message.getIdentifiers());
            this.broadcast(MDCDecodeEvent.builder(this.getDecodeEventType(type), mdc.getTimestamp()).details(mdc.toString()).identifiers(ic).build());
            switch (type) {
                case ANI: {
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.CALL));
                    break;
                }
                default: {
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
                }
            }
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("=============================\n");
        sb.append("Decoder:\tMDC-1200\n\n");
        sb.append("MDC-1200 Idents\n");
        if (this.mIdents.isEmpty()) {
            sb.append("  None\n");
        } else {
            for (MDC1200Identifier mIdent : this.mIdents) {
                sb.append("  ").append(mIdent).append("\n");
            }
        }
        sb.append("MDC-1200 Emergency Idents\n");
        if (this.mEmergencyIdents.isEmpty()) {
            sb.append("  None\n");
        } else {
            Iterator<MDC1200Identifier> it = this.mEmergencyIdents.iterator();
            while (it.hasNext()) {
                for (MDC1200Identifier mIdent : this.mIdents) {
                    sb.append("  ").append(mIdent).append("\n");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                break;
            }
        }
    }

    private DecodeEventType getDecodeEventType(MDCMessageType messageType) {
        switch (messageType) {
            case ANI: {
                return DecodeEventType.ID_ANI;
            }
            case ACKNOWLEDGE: {
                return DecodeEventType.RESPONSE;
            }
            case EMERGENCY: {
                return DecodeEventType.EMERGENCY;
            }
            case PAGING: {
                return DecodeEventType.PAGE;
            }
            case STATUS: {
                return DecodeEventType.STATUS;
            }
        }
        return DecodeEventType.UNKNOWN;
    }
}

