/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrstandard;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.ltrstandard.message.Call;
import io.github.dsheirer.module.decode.ltrstandard.message.CallEnd;
import io.github.dsheirer.module.decode.ltrstandard.message.Idle;
import io.github.dsheirer.module.decode.ltrstandard.message.LTRMessage;
import io.github.dsheirer.module.decode.ltrstandard.message.UnknownMessage;
import io.github.dsheirer.sample.Listener;

public class LTRStandardMessageProcessor
implements Listener<CorrectedBinaryMessage> {
    private MessageDirection mDirection;
    private Listener<IMessage> mMessageListener;

    public LTRStandardMessageProcessor(MessageDirection direction) {
        this.mDirection = direction;
    }

    @Override
    public void receive(CorrectedBinaryMessage binaryMessage) {
        if (this.mMessageListener != null) {
            CRC crc;
            if (this.mDirection == MessageDirection.ISW) {
                binaryMessage.flip(0, 40);
            }
            if ((crc = CRCLTR.check(binaryMessage, this.mDirection)).passes()) {
                int channel = binaryMessage.getInt(LTRMessage.CHANNEL);
                int home = binaryMessage.getInt(LTRMessage.HOME_REPEATER);
                int free = binaryMessage.getInt(LTRMessage.FREE);
                int group = binaryMessage.getInt(LTRMessage.GROUP);
                LTRMessage message = this.isValidChannel(channel) && this.isValidChannel(home) && this.isValidFreeChannel(free) ? (channel == free && group == 255 ? new Idle(binaryMessage, this.mDirection, crc) : new Call(binaryMessage, this.mDirection, crc)) : (channel == 31 && this.isValidChannel(home) && this.isValidFreeChannel(free) ? new CallEnd(binaryMessage, this.mDirection, crc) : new UnknownMessage(binaryMessage, this.mDirection, crc));
                this.mMessageListener.receive(message);
            }
        }
    }

    private boolean isValidChannel(int channel) {
        return 1 <= channel && channel <= 20;
    }

    private boolean isValidFreeChannel(int channel) {
        return 0 <= channel && channel <= 20;
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }
}

