/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.identifier.LtrSiteIdentifier;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.ArrayList;
import java.util.List;

public class SiteId
extends LtrNetOswMessage {
    private LtrSiteIdentifier mLtrSiteIdentifier;
    private List<Identifier> mIdentifiers;

    public SiteId(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_SITE_ID;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("SITE:").append(this.getSiteID());
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public LtrSiteIdentifier getSiteID() {
        if (this.mLtrSiteIdentifier == null) {
            this.mLtrSiteIdentifier = LtrSiteIdentifier.create(this.getMessage().getInt(23, 32));
        }
        return this.mLtrSiteIdentifier;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSiteID());
        }
        return this.mIdentifiers;
    }
}

