/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.isw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.esn.ESNIdentifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.isw.LtrNetIswMessage;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RegistrationRequestEsnLow;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;

public class RegistrationRequestEsnHigh
extends LtrNetIswMessage {
    private RegistrationRequestEsnLow mRegistrationRequestEsnLow;
    private ESNIdentifier mESNIdentifier;
    private List<Identifier> mIdentifiers;

    public RegistrationRequestEsnHigh(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.ISW_REGISTRATION_REQUEST_ESN_HIGH;
    }

    public void setEsnLowMessage(RegistrationRequestEsnLow message) {
        if (message != null) {
            this.mRegistrationRequestEsnLow = message;
        }
    }

    public boolean isCompleteEsn() {
        return this.mRegistrationRequestEsnLow != null;
    }

    public ESNIdentifier getESN() {
        if (this.mESNIdentifier == null) {
            this.mESNIdentifier = ESNIdentifier.create(this.getESNHigh() + (this.mRegistrationRequestEsnLow != null ? this.mRegistrationRequestEsnLow.getESNLow() : "xxxx"), Protocol.LTR_NET, Role.FROM);
        }
        return this.mESNIdentifier;
    }

    public String getESNHigh() {
        int esnHigh = this.getMessage().getInt(SIXTEEN_BITS);
        return String.format("%04X", esnHigh & 0xFFFF);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ESN HIGH: ").append(this.getESN());
        return sb.toString();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getESN());
        }
        return this.mIdentifiers;
    }
}

