/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.channel;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.protocol.Protocol;

public class LtrNetChannel
implements IChannelDescriptor,
Comparable<LtrNetChannel> {
    private long mDownlink;
    private long mUplink;
    private int mChannel;

    public LtrNetChannel(int channel) {
        this.mChannel = channel;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public void setDownlink(long downlink) {
        this.mDownlink = downlink;
    }

    public void setUplink(long uplink) {
        this.mUplink = uplink;
    }

    @Override
    public long getDownlinkFrequency() {
        return this.mDownlink;
    }

    @Override
    public long getUplinkFrequency() {
        return this.mUplink;
    }

    @Override
    public int[] getFrequencyBandIdentifiers() {
        return new int[0];
    }

    @Override
    public void setFrequencyBand(IFrequencyBand bandIdentifier) {
    }

    @Override
    public boolean isTDMAChannel() {
        return false;
    }

    @Override
    public int getTimeslotCount() {
        return 0;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.LTR_NET;
    }

    public String toString() {
        return String.valueOf(this.getChannel());
    }

    public String description() {
        return "TRANSMIT: " + this.getDownlinkFrequency() + " RECEIVE:" + this.getUplinkFrequency();
    }

    @Override
    public int compareTo(LtrNetChannel o) {
        return Integer.compare(this.getChannel(), o.getChannel());
    }

    public boolean equals(Object o) {
        if (!(o instanceof LtrNetChannel)) {
            return false;
        }
        return this.compareTo((LtrNetChannel)o) == 0;
    }
}

