/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.ltrnet.message.LtrNetMessage;
import io.github.dsheirer.module.decode.ltrnet.message.LtrNetMessageFactory;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RegistrationRequestEsnHigh;
import io.github.dsheirer.module.decode.ltrnet.message.isw.RegistrationRequestEsnLow;
import io.github.dsheirer.module.decode.ltrnet.message.osw.ReceiveFrequencyHigh;
import io.github.dsheirer.module.decode.ltrnet.message.osw.ReceiveFrequencyLow;
import io.github.dsheirer.module.decode.ltrnet.message.osw.TransmitFrequencyHigh;
import io.github.dsheirer.module.decode.ltrnet.message.osw.TransmitFrequencyLow;
import io.github.dsheirer.sample.Listener;
import java.util.HashMap;
import java.util.Map;

public class LTRNetMessageProcessor
implements Listener<CorrectedBinaryMessage> {
    private Listener<IMessage> mMessageListener;
    private Map<Integer, ReceiveFrequencyHigh> mReceiveHighMessageMap = new HashMap<Integer, ReceiveFrequencyHigh>();
    private Map<Integer, ReceiveFrequencyLow> mReceiveLowMessageMap = new HashMap<Integer, ReceiveFrequencyLow>();
    private Map<Integer, TransmitFrequencyHigh> mTransmitHighMessageMap = new HashMap<Integer, TransmitFrequencyHigh>();
    private Map<Integer, TransmitFrequencyLow> mTransmitLowMessageMap = new HashMap<Integer, TransmitFrequencyLow>();
    private RegistrationRequestEsnHigh mRegistrationRequestEsnHighMessage;
    private RegistrationRequestEsnLow mRegistrationRequestEsnLowMessage;
    private MessageDirection mDirection;

    public LTRNetMessageProcessor(MessageDirection direction) {
        this.mDirection = direction;
    }

    @Override
    public void receive(CorrectedBinaryMessage buffer) {
        LtrNetMessage message = LtrNetMessageFactory.create(this.mDirection, buffer, System.currentTimeMillis());
        if (message.isValid()) {
            switch (message.getLtrNetMessageType()) {
                case OSW_TRANSMIT_FREQUENCY_HIGH: {
                    if (!(message instanceof TransmitFrequencyHigh)) break;
                    TransmitFrequencyHigh transmitFrequencyHigh = (TransmitFrequencyHigh)message;
                    this.mTransmitHighMessageMap.put(transmitFrequencyHigh.getChannel(), transmitFrequencyHigh);
                    transmitFrequencyHigh.setFrequencyLow(this.mTransmitLowMessageMap.get(transmitFrequencyHigh.getChannel()));
                    break;
                }
                case OSW_TRANSMIT_FREQUENCY_LOW: {
                    if (!(message instanceof TransmitFrequencyLow)) break;
                    TransmitFrequencyLow transmitFrequencyLow = (TransmitFrequencyLow)message;
                    this.mTransmitLowMessageMap.put(transmitFrequencyLow.getChannel(), transmitFrequencyLow);
                    transmitFrequencyLow.setFrequencyHigh(this.mTransmitHighMessageMap.get(transmitFrequencyLow.getChannel()));
                    break;
                }
                case OSW_RECEIVE_FREQUENCY_HIGH: {
                    if (!(message instanceof ReceiveFrequencyHigh)) break;
                    ReceiveFrequencyHigh receiveFrequencyHigh = (ReceiveFrequencyHigh)message;
                    this.mReceiveHighMessageMap.put(receiveFrequencyHigh.getChannel(), receiveFrequencyHigh);
                    receiveFrequencyHigh.setFrequencyLow(this.mReceiveLowMessageMap.get(receiveFrequencyHigh.getChannel()));
                    break;
                }
                case OSW_RECEIVE_FREQUENCY_LOW: {
                    if (!(message instanceof ReceiveFrequencyLow)) break;
                    ReceiveFrequencyLow receiveFrequencyLow = (ReceiveFrequencyLow)message;
                    this.mReceiveLowMessageMap.put(receiveFrequencyLow.getChannel(), receiveFrequencyLow);
                    receiveFrequencyLow.setFrequencyHigh(this.mReceiveHighMessageMap.get(receiveFrequencyLow.getChannel()));
                    break;
                }
                case ISW_REGISTRATION_REQUEST_ESN_HIGH: {
                    if (!(message instanceof RegistrationRequestEsnHigh)) break;
                    ((RegistrationRequestEsnHigh)message).setEsnLowMessage(this.mRegistrationRequestEsnLowMessage);
                    break;
                }
                case ISW_REGISTRATION_REQUEST_ESN_LOW: {
                    if (!(message instanceof RegistrationRequestEsnLow)) break;
                    ((RegistrationRequestEsnLow)message).setESNHighMessage(this.mRegistrationRequestEsnHighMessage);
                    break;
                }
                case ISW_CALL_START: 
                case ISW_CALL_END: {
                    this.mRegistrationRequestEsnHighMessage = null;
                    this.mRegistrationRequestEsnLowMessage = null;
                }
            }
            if (this.mMessageListener != null) {
                this.mMessageListener.receive(message);
            }
        }
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }
}

