/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.lj1200;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCLJ;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.esn.ESNIdentifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.lj1200.FunctionAndReplyCodeIdentifier;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LJ1200Message
extends Message {
    private static final Logger mLog = LoggerFactory.getLogger(LJ1200Message.class);
    public static final String[] REPLY_CODE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"};
    public static int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static int[] VRC = new int[]{23, 22, 21, 20, 19, 18, 17, 16};
    public static int[] LRC = new int[]{31, 30, 29, 28, 27, 26, 25, 24};
    public static int[] FUNCTION = new int[]{35, 34, 33, 32};
    public static int[] ADDRESS = new int[]{63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36};
    public static int[] REPLY_1 = new int[]{39, 38, 37, 36, 43};
    public static int[] REPLY_2 = new int[]{42, 41, 40, 47, 46};
    public static int[] REPLY_3 = new int[]{45, 44, 51, 50, 49};
    public static int[] REPLY_4 = new int[]{48, 55, 54, 53, 52};
    public static int[] REPLY_5 = new int[]{59, 58, 57, 56, 63};
    public static int[] MESSAGE_CRC = new int[]{79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64};
    private BinaryMessage mMessage;
    private CRC mCRC;
    private FunctionAndReplyCodeIdentifier mFunctionAndReplyCodeIdentifier;
    private ESNIdentifier mTransponderIdentifier;
    private List<Identifier> mIdentifiers;

    public LJ1200Message(BinaryMessage message) {
        this.mMessage = message;
        this.checkCRC();
        switch (this.mCRC) {
            case CORRECTED: {
                mLog.debug("CORR:" + message.toString());
                break;
            }
            case FAILED_CRC: {
                mLog.debug("FAIL:" + message.toString());
                break;
            }
            case PASSED: {
                mLog.debug("PASS:" + message.toString());
                break;
            }
        }
    }

    private void checkCRC() {
        this.mCRC = CRCLJ.checkAndCorrect(this.mMessage);
    }

    @Override
    public boolean isValid() {
        return this.mCRC == CRC.PASSED || this.mCRC == CRC.CORRECTED;
    }

    public FunctionAndReplyCodeIdentifier getFunctionAndReplyCodeIdentifier() {
        if (this.mFunctionAndReplyCodeIdentifier == null) {
            this.mFunctionAndReplyCodeIdentifier = FunctionAndReplyCodeIdentifier.create(this.getFunction(), this.getReplyCode());
        }
        return this.mFunctionAndReplyCodeIdentifier;
    }

    public ESNIdentifier getTransponder() {
        if (this.mTransponderIdentifier == null) {
            this.mTransponderIdentifier = ESNIdentifier.create(this.getAddress(), Protocol.LOJACK, Role.TO);
        }
        return this.mTransponderIdentifier;
    }

    public String getVRC() {
        return this.mMessage.getHex(VRC, 2);
    }

    public String getLRC() {
        return this.mMessage.getHex(LRC, 2);
    }

    public String getCRC() {
        return this.mMessage.getHex(MESSAGE_CRC, 4);
    }

    public Function getFunction() {
        return Function.fromValue(this.mMessage.getInt(FUNCTION), this.mMessage.getInt(REPLY_3));
    }

    public String getAddress() {
        return this.mMessage.getHex(ADDRESS, 7);
    }

    public String getReplyCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(REPLY_CODE[this.mMessage.getInt(REPLY_1)]);
        sb.append(REPLY_CODE[this.mMessage.getInt(REPLY_2)]);
        sb.append(REPLY_CODE[this.mMessage.getInt(REPLY_3)]);
        sb.append(REPLY_CODE[this.mMessage.getInt(REPLY_4)]);
        sb.append(REPLY_CODE[this.mMessage.getInt(REPLY_5)]);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Function function = this.getFunction();
        sb.append("FUNCTION: ");
        sb.append(function.toString());
        switch (function) {
            case F1_SITE_ID: {
                sb.append(" SITE [");
                break;
            }
            default: {
                sb.append(" REPLY CODE [");
            }
        }
        sb.append(this.getReplyCode());
        sb.append("] ADDRESS [");
        sb.append(this.getAddress());
        sb.append("] VRC [").append(this.getVRC());
        sb.append("] LRC [").append(this.getLRC());
        sb.append("] CRC [").append(this.getCRC());
        sb.append("]");
        return sb.toString();
    }

    public String pad(String value, int places, String padCharacter) {
        return StringUtils.rightPad((String)value, (int)places, (String)padCharacter);
    }

    public String format(int number, int decimalPlaces) {
        return StringUtils.leftPad((String)Integer.valueOf(number).toString(), (int)decimalPlaces, (char)'0');
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.LOJACK;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getFunctionAndReplyCodeIdentifier());
            this.mIdentifiers.add(this.getTransponder());
        }
        return this.mIdentifiers;
    }

    public static enum Function {
        F0_UNKNOWN("0-UNKNOWN"),
        F1_SITE_ID("1Y-SITE ID"),
        F1_SPEED_UP("1-SPEED UP"),
        F2_TEST("2-TOWER TEST"),
        F3_DEACTIVATE("3-DEACTIVATE"),
        F4_ACTIVATE("4-ACTIVATE"),
        F5_TRANSPONDER_TEST_REPLY("5-TRANSPONDER TEST REPLY"),
        F6_TRANSPONDER_TEST_COMMAND("6-TRANSPONDER TEST COMMAND"),
        F7_QUIET_COMMAND("7-QUIET COMMAND"),
        F8_UNKNOWN("8-UNKNOWN"),
        F9_UNKNOWN("9-UNKNOWN"),
        FA_UNKNOWN("A-UNKNOWN"),
        FB_UNKNOWN("B-UNKNOWN"),
        FC_ALT_DEACTIVATE("C-ALT-DEACTIVATE"),
        FD_UNKNOWN("D-UNKNOWN"),
        FE_UNKNOWN("E-UNKNOWN"),
        FF_TRACK_PULSE("F-TRACK PULSE"),
        UNKNOWN("UNKNOWN");

        private String mLabel;

        private Function(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.getLabel();
        }

        public static Function fromValue(int value, int replyCodeDigit3) {
            switch (value) {
                case 0: {
                    return F0_UNKNOWN;
                }
                case 1: {
                    if (replyCodeDigit3 == 31) {
                        return F1_SITE_ID;
                    }
                    return F1_SPEED_UP;
                }
                case 2: {
                    return F2_TEST;
                }
                case 3: {
                    return F3_DEACTIVATE;
                }
                case 4: {
                    return F4_ACTIVATE;
                }
                case 5: {
                    return F5_TRANSPONDER_TEST_REPLY;
                }
                case 6: {
                    return F6_TRANSPONDER_TEST_COMMAND;
                }
                case 7: {
                    return F7_QUIET_COMMAND;
                }
                case 8: {
                    return F8_UNKNOWN;
                }
                case 9: {
                    return F9_UNKNOWN;
                }
                case 10: {
                    return FA_UNKNOWN;
                }
                case 11: {
                    return FB_UNKNOWN;
                }
                case 12: {
                    return FC_ALT_DEACTIVATE;
                }
                case 13: {
                    return FD_UNKNOWN;
                }
                case 14: {
                    return FE_UNKNOWN;
                }
                case 15: {
                    return FF_TRACK_PULSE;
                }
            }
            return UNKNOWN;
        }
    }
}

